/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * SY 11-17-2004 v8.0164 QA70-6721 ASCIMP_OPTIONS_USE_GETNBOX					*
 * EJP 12-17-2004 QA70-6721 ASCIMP_OPTIONS_USE_GETNBOX							*
 * EJP 2005-03-23 v8.0209 QA70-7433 IMPORT_CSV_FILES							*
 * EJP 2005-05-04 v8.0229 QA70-6555 NEW_IMPORT_MODES							*
 * SY 05/17/2005 QA70-7650 v8.0235 MORE_IMPORT_MODE_IN_OLD_ASCII_IMPORT_DLG		*
 * EJP 2005-06-27 v8.0258 QA70-5705 ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS			*
 * EJP 2005-07-28 v8.0277 FIX_SUPPORT_FOR_IMPORT_ASCII_INTO_EXCEL_SHEET			*
 * EJP 2006-01-17 v8.0358 UNIQUE_ID_FOR_HELP_WITH_GETN_BOX						*
 * SY 2006-10-03 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET						*
 * AW 10/17/06 NEW_IMPASC_OPTIONS												*
 * Hong 11/13/06 FIX_IMPORT_MODE_CHANGED_INREASONABLE							*
 * Sim 11/14/06 FIX_COLUMN_WIDTHS_BUG											*
 * Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF					*
 * Hong 03/02/07 QA-9418 ADD_REPEAT_IMPORT										*
 * Hong 03/02/07 QA80-9015 ADD_PARTIAL_IMPORT_OPTION							*
 * Hong 03/06/07 CHANGE_TRIM_FNAME_OFFSET_FROM_ZERO_TO_ONE						*
 * Sim 03-16-2007 QA80-9418-P1 FIX_LONG_NAME_NOT_UPDATE_WHEN_REIMPORT			*
 * Sim 03-17-2007 CHANGE_LABEL_OF_NON_NUMERIC_DATA								*
 * Hong 03/23/07 v8.0589b IMPASC_ADD_TEXT_QUALIFIER_OPTION						*
 * Hong 03/27/07 v8.0590 MORE_RESTRICTION_FOR_REIMPORT							*
 * Sim 04-06-2007 MAKE_IMPWIZ_AND_ASCXF_ARE_CONSISTENT							*
 * Sim 04-12-2007 REORGANIZE_PARTIAL_RANGE_IMPORT								*
 * Sim 04-28-2007 FIX_CONVERT_FILTER_TO_GETN									*
 * Sim 05-24-2007 SUPPORT_CONVERT_OPTIONS_TO_FILTER 							*
 * Sim 05-25-2007 MOVE_SPARKLINE_TO_OPTIONS_TREE								*
 * Sim 05-29-2007 MAKE_HEADER_LINES_CONSISTENT_WITH_IMP_WIZ						*
 * Sim 05-29-2007 ONLY_ONE_IMPORT_MODE_SAME_AS_IMP_WIZ							*
 * Sim 06-04-2007 SOME_PAGES_TO_BE_EXCLUDED_FROM_MANAGER						*
 * Justin 2007-06-19 MODIFY_THE_TAGNAME_OF_NODE_IN_OPTION_TREE (not add code mark)*
 * Hong QA80-9972 REMOVE_ORIGIN_SETTING_FOR_NUMERIC_SEPARATOR					*
 * Sim 07-11-2007 CHANGE_ASCII_IMPORT_DEFAULT_MODE								*
 * Sim 07-13-2007 IMPORT_TO_GRAPH_SHOULD_KEEP_WORKSHEET_IN_SIGHT				*
 * Sim 08-06-2007 SUPPORT_SMART_SPARKLINE										*
 * Sim 08-07-2007 FIX_IMP_ASC_OPTIONS											*
 *	Hong 09/07/07 v8.698b CONSISTENT_GUI_CONTROL								*
 *	Hong 09/26/07 QA80-9910 v8.0709 FIX_FAIL_PLOT_ALL_DATA_WHEN_DEFAULT_TEMPLATE_HAVE_MULTI_COLS
 *	Hong 12/05/07 v8.0761 IMPASC_ALLOW_IMPORT_ALL_TEXT_DATA						*
 *	Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME		*
 * Sim 03-31-2008 QA80-11351 DEFAULT_UNCHECK_AUTO_RENAME						*
 *	Hong 04/16/08 QA80-11397 CENTRALIZE_WITH_BETTER_LABEL_OF_RENAME_OPTIONS		*
 *	Hong 06/16/08 QA80-10541 DISABLE_IMPORT_MODE_WHEN_REIMPORT					*
 *	Hong 07/10/08 v8.0899 FIX_RUNTIME_ERROR_FOR_NOT_FULL_GETN_TREE				*
 *	Hong 07/10/08 v8.899 FIX_DEFAULT_VALUE_LOST_WHEN_PARTIAL_GETN_TREE			*
 *	Sim 08-07-2008 v8.0918 QA80-11969 MULTI_ASC_IMP_SUPPORT_TEMPLATE			*
 *	Hong 08/08/08 v8.0918b FIX_SEL_OTHER_FAIL_ENABLE_OTHER_DELIMITER			*
 *	Hong 12/19/08 QA80-12736 FIX_IMPORT_ASCII_FAIL_IMPORT_TO_GRAPH				*
 *	Sim 01-04-2008 QA12890-P5 IMP_ASC_XF_SUPPORT_SET_CUSTOM_DATE				*
 *	Kyle 01/04/2009 QA70-12890-P4 CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT
 *	Hong 08/12/09 IMPASC_DEFAULT_HEADER_COMMENT_TO_START_FROM_3RD_LINE_SUGGESTED_BY_EASWAR
 *	Hong 08/31/09 QA80-12899 IMP_WIZ_SUPPORT_KEEP_COL_FMTS_IN_TEMPLATE			*
 *	Folger 09/29/09 QA80-14392 IMPASC_FAILS_TO_IMPORT_NUMERIC_DATA_ON_GOS_WITH_DEFAULT_OPTIONS
 *	Hong 02/09/10 QA80-14079-P6 FIX_IMPASC_SINGLE_CHAR_IN_DELIMITERS_FAIL_TO_WORK
 *	Hong 02/09/10 QA80-14709-P7 FIX_IMPASC_OPTION_SHOW_HIDE						*
 *	Hong 03/11/10 QA80-15192 SUPPORT_EDIT_BINARY_FILTER_CREATED_BY_IMPWIZ		*
 *	Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
#include <GetNBox.h>
#include <okocUtils.h>

#pragma labtalk(0) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS
 
#include "fu_utils.h"  //CPY 9/15/06 I found this file cannot load due to some code in import_utils.c depends on this

////////////////////////////////////////////////////////////////////////////////////
#include "AscImpOptions.h"  




/// EJP 12-17-2004 QA70-6721 ASCIMP_OPTIONS_USE_GETNBOX
#define ASCIMP_OPTIONS_USE_GETN_ID
/// end ASCIMP_OPTIONS_USE_GETNBOX

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
/// SY 05/17/2005 QA70-7650 v8.0235 MORE_IMPORT_MODE_IN_OLD_ASCII_IMPORT_DLG
#include "Import_Utils.h"
/// end MORE_IMPORT_MODE_IN_OLD_ASCII_IMPORT_DLG

#define SUBHEADERMAX 20 		/// AW 10/17/06 NEW_IMPASC_OPTIONS, now, we just have 5 which are shortname, longtime, unit, comments, parameters, user parameters

#define SZ_LISTITEM_NONE		_L("<none>")
#define SZ_LISTITEM_UNKNOWN		_L("<unknown>")
#define SZ_LISTITEM_AUTO		_L("<auto>")
#define SZ_LISTITEM_ALL			_L("<all>")
#define SZ_LISTITEM_END			_L("<end>")


enum {DATASTRUCT_FIXEDCOLWIDTHS=0, DATASTRUCT_DELIMITED};
enum {SUBHDRLINES_AUTO, SUBHDRLINES_SPECIFY};

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
int DoAsciiImport()
{
	Page pg = Project.Pages();
	if( !pg )
		return 1;

	Layer ly = pg.Layers();
	if( !ly )
		return 1;
	
	Worksheet wks(ly);
	if( !wks )
		return 1;
	
	if( DoAsciiImportOptionsDialog(wks) >= 0 )
	{
		string strFile = "D:\\share\\data\\ascii\\axes.dat";

		ASCIMP ai;
		wks.GetASCIMP(ai);
		wks.ImportASCII(strFile, ai);
	}
	
	return 0;
}

int AscImpOptionsActive()
{
	Page pg = Project.Pages();
	if( !pg )
		return -1; // error

	Layer ly = pg.Layers();
	if( !ly )
		return -1; // error
	
	Worksheet wks(ly);
	if( !wks )
		return -1;

	return DoAsciiImportOptionsDialog(wks);
}

int DoAsciiImportOptionsDialog(Worksheet& wks)
{
	ASCIMP ai;
	wks.GetASCIMP(ai);

	if( 0 == DoAsciiImportOptionsDialog(ai) ) // if user clicked OK
	{
		wks.SetASCIMP(ai);
		return 0; // user clicked OK
	}
	return 1; // user canceled
}

/// Hong 03/11/10 QA80-15192 SUPPORT_EDIT_BINARY_FILTER_CREATED_BY_IMPWIZ
static void _construct_rename_options(TreeNode& tr)
{
	GETN_USE(tr)
	
	GETN_BEGIN_BRANCH(Names, STR_LBL_RENAME_OPTIONS)
		GETN_CHECK(AutoNames, STR_LBL_AUTO_RENAME, 0) GETN_ID(IDE_DISP_IMP_AUTO_RENAME)
			GETN_OPTION_EVENT_EX(OnChangeRenameOptions)
		GETN_CHECK(FNameToSht, STR_LBL_RENAME_SHEET, 0) GETN_ID(IDE_ASCIMP_RENAMEWKS)
			GETN_OPTION_EVENT_EX(OnChangeRenameOptions)
		GETN_NUM(FNameToShtFrom, STR_LBL_TRIM_FROM, 1) GETN_ID(IDE_DISPIMP_RENAMEWKSTRIMFNAMEFROM)
		GETN_NUM(FNameToShtTo, STR_LBL_TRIM_TO, 0) GETN_ID(IDE_DISPIMP_RENAMEWKSTRIMFNAMETO)
		GETN_CHECK(FNameToBk, STR_LBL_RENAME_BOOK, 0) GETN_ID(IDE_ASCIMP_FILENAME2WKS)
			GETN_OPTION_EVENT_EX(OnChangeRenameOptions)
		GETN_NUM(FNameToBkFrom, STR_LBL_TRIM_FROM, 1) GETN_ID(IDE_DISPIMP_RENAMEWKBKTRIMFNAMEFROM)
		GETN_NUM(FNameToBkTo, STR_LBL_TRIM_TO, 0) GETN_ID(IDE_DISPIMP_RENAMEWKBKTRIMFNAMETO)
		GETN_CHECK(FNameToBkLnOnly, STR_LBL_LONG_NAME_ONLY, 0) GETN_ID(IDE_ASCIMP_WKBKLNONLY)
		GETN_CHECK(FPathToBk, STR_LBL_BOOK_INCLUDE_PATH, 0) GETN_ID(IDE_ASCIMP_ADDPATH4WKBK)
		GETN_CHECK(FNameToBkComm, STR_LBL_APPEND_FNAME_TO_BKCMT, 0) GETN_ID(IDE_ASCIMP_FILENAME2WKSCOMMENT)
			GETN_OPTION_EVENT_EX(OnChangeRenameOptions)
		GETN_CHECK(FNameToColComm, STR_LBL_APPEND_FNAME_TO_COLCMT, 0) GETN_ID(IDE_ASCIMP_FILENAME2COLCOMMENT)
			GETN_OPTION_EVENT_EX(OnChangeRenameOptions)
		GETN_CHECK(FPathToComm, STR_LBL_APPEND_PATH_TO_FNAME, 0) GETN_ID(IDE_ASCIMP_ADDPATH)
	GETN_END_BRANCH(Names)
}

static void _construct_partial_options(TreeNode& tr)
{
	GETN_USE(tr)
	
	GETN_BEGIN_BRANCH(PartImp, STR_LBL_PARTIAL_IMPORT)
		GETN_CHECK(Partial, STR_LBL_PARTIAL_IMPORT, 0) GETN_ID(IDE_ASCIMP_PARTIAL) 
			GETN_OPTION_EVENT_EX(OnChangePartialImport)
		GETN_NUM(FirstCol, _L("From Column"), 0) GETN_ID(IDE_ASCIMP_PARTIALC1)
		GETN_NUM(LastCol, _L("To Column"), -1) GETN_ID(IDE_ASCIMP_PARTIALC2)
		GETN_NUM(FirstRow, _L("From Row"), 0) GETN_ID(IDE_ASCIMP_PARTIALR1)
		GETN_NUM(ReadRows, _L("Read Rows"), 1) GETN_ID(IDE_ASCIMP_READROWS)
		GETN_NUM(SkipRows, _L("Skip Data Rows"), 0) GETN_ID(IDE_ASCIMP_SKIPROWS)
			GETN_OPTION_EVENT_EX(OnChangeSkipRow)
		GETN_NUM(LastRow, _L("To Row"), -1) GETN_ID(IDE_ASCIMP_PARTIALR2)
	GETN_END_BRANCH(PartImp)
}

static void _get_rename_options(const TreeNode& trOptions, bool& bRenameWks, DWORD& dwFlags)
{
	bRenameWks = (trOptions.FNameToSht.nVal ? 1 : 0);
	O_SET_BIT(dwFlags, AI_FLAG_FNAME_TO_WKBK_NAME, trOptions.FNameToBk.nVal);
	O_SET_BIT(dwFlags, AI_FLAG_FNAME_TO_WKBK_LONG_NAME_ONLY, trOptions.FNameToBkLnOnly.nVal);
	O_SET_BIT(dwFlags, AI_FLAG_REMOVE_FNAME_PATH_FOR_WKBK_NAME, 0 == trOptions.FPathToBk.nVal);
	O_SET_BIT(dwFlags, AI_FLAG_FNAME_TO_WKBK_COMMENTS, trOptions.FNameToBkComm.nVal);
	O_SET_BIT(dwFlags, AI_FLAG_FNAME_TO_COL_COMMENTS, trOptions.FNameToColComm.nVal);
	O_SET_BIT(dwFlags, AI_FLAG_REMOVE_FNAME_PATH, 0 == trOptions.FPathToComm.nVal);
}

static void _set_rename_options(TreeNode& trOptions, bool bRenameWks, DWORD dwFlags)
{
	trOptions.FNameToSht.nVal = bRenameWks;
	trOptions.FNameToBk.nVal = (dwFlags & AI_FLAG_FNAME_TO_WKBK_NAME) ? 1 : 0;
	trOptions.FNameToBkLnOnly.nVal = (dwFlags & AI_FLAG_FNAME_TO_WKBK_LONG_NAME_ONLY) ? 1 : 0;
	trOptions.FPathToBk.nVal = (dwFlags & AI_FLAG_REMOVE_FNAME_PATH_FOR_WKBK_NAME) ? 0 : 1;
	trOptions.FNameToBkComm.nVal = (dwFlags & AI_FLAG_FNAME_TO_WKBK_COMMENTS) ? 1 : 0;
	trOptions.FNameToColComm.nVal = (dwFlags & AI_FLAG_FNAME_TO_COL_COMMENTS) ? 1 : 0;
	trOptions.FPathToComm.nVal = (dwFlags & AI_FLAG_REMOVE_FNAME_PATH) ? 0 : 1;
}
/// end SUPPORT_EDIT_BINARY_FILTER_CREATED_BY_IMPWIZ

/*
int DoAsciiImportOptionsDialog(ASCIMP& ai)
{
	Tree tr;
	tr = GetASCIMPGetNTree();
	if( tr )
	{
		ASCIMPToGetNTree(tr, ai);
		if( GetNBox(tr, _L("ASCII Import Options")) )
		{
			GetNTreeToASCIMP(ai, tr);
			return 0; // user clicked OK
		}
	}
	return 1; // user canceled
}

static Tree GetASCIMPGetNTree()
*/
/// AW 08/16/06 ADD_IMPASC
/*
int DoAsciiImportOptionsDialog(ASCIMP& ai)
{
	/// EJP 2006-01-17 v8.0358 UNIQUE_ID_FOR_HELP_WITH_GETN_BOX
	///GETN_TREE(tr)
	GETN_TREE(tr) GETN_ID_BRANCH(IDST_DLG_ASCIMP_OPTIONS)
	/// end UNIQUE_ID_FOR_HELP_WITH_GETN_BOX

	GETN_OPTION_GRIDLINE(flexGridRaisedVert) // Option to add vertical divider line
	GETN_OPTION_EDIT_ALIGN("0|0|0") // left align checkbox|numbers|strings

	/// SY 11-17-2004 v8.0164 QA70-6721 ASCIMP_OPTIONS_USE_GETNBOX
	GETN_BUTTON(UpdateOptions, _L("Update Options"), _L("Update Options in Worksheet"))
		GETN_OPTION_EVENT(OnClickUpdateOptions) 
	/// end QA70-6721 ASCIMP_OPTIONS_USE_GETNBOX

	GETN_BEGIN_BRANCH(FileStruct, _L("File Structure"))
		GETN_LIST(DataStruct, _L("Data Structure"), -1, _L("Fixed column widths|Delimited"))
			GETN_ID(IDE_ASCIMP_DELIMITED)
			GETN_OPTION_EVENT(OnChangeDataStruct)
		GETN_LIST(Delimiter, _L("Delimiter"), -1, _L("Unknown|Comma(,)|Tab|Space|Other"))
			GETN_ID(IDE_ASCIMP_DELIMCODE)
			GETN_OPTION_EVENT(OnChangeDelimiter)
		GETN_STR(OtherDelimiter, _L("Other Delimiter"), "")
			//GETN_ID(IDE_ASCIMP_DELIMCHAR)
		GETN_STR(ColumnWidths, _L("Column Widths (e.g. 6,3,3,8)"), "")
			GETN_ID(IDE_ASCIMP_COLWIDTHS)
		/// EJP 2005-06-27 v8.0258 QA70-5705 ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS
		GETN_LIST(NumericSeparator, _L("Numeric Separators"), -1, _L("Origin's Setting|1,000.00|1.000,00|1 000,00|1'000.00"))
			//GETN_ID(IDE_ASCIMP_NUMSEP)
		/// end ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS
	GETN_END_BRANCH(FileStruct)

	GETN_BEGIN_BRANCH(Columns, _L("Columns"))
		/// SY 05/24/2005 v8.0240 QA70-6721 ASCIMP_OPTIONS_USE_GETNBOX
		///	GETN_COMBO(NumColumns, _L("Number of columns"), -1, _L("|<unknown>|1|2|3|4|5|6|7|8|9|10"))
		GETN_COMBO(NumColumns, _L("Number of columns"), -1, _L("<unknown>|1|2|3|4|5|6|7|8|9|10"))
		/// end ASCIMP_OPTIONS_USE_GETNBOX
			GETN_ID(IDE_ASCIMP_NUMCOLUMNS)
			GETN_OPTION_SPECIALVALS("0")
		GETN_CHECK(AutoColTypes, _L("Auto determine column types"), 0)
			GETN_ID(IDE_ASCIMP_AUTOCOLTYPES)
			GETN_OPTION_EVENT(OnChangeAutoColTypes)
		GETN_NUM(NumTestLines, _L("Number of lines for structure testing"), -1)
			GETN_ID(IDE_ASCIMP_TESTLINES)
	GETN_END_BRANCH(Columns)
	
	GETN_BEGIN_BRANCH(HeaderLines, _L("Header Lines"))
		/// SY 05/24/2005 v8.0240 QA70-6721 ASCIMP_OPTIONS_USE_GETNBOX
		///GETN_COMBO(MainHeaderLines, _L("Number of header lines"), 0, "<none>|1|2|3|4|5|6|7|8|9|10")
		GETN_COMBO(MainHeaderLines, _L("Number of Main header lines"), -1, _L("<none>|1|2|3|4|5|6|7|8|9|10"))
		/// end ASCIMP_OPTIONS_USE_GETNBOX
			GETN_ID(IDE_ASCIMP_HEADLINES)
			GETN_OPTION_SPECIALVALS("0")
			GETN_OPTION_EVENT(OnChangeMainHeaderLines)
///		GETN_CHECK(AutoSubHeaderLines, _L("Auto determine subheader lines"), 0) GETN_ID(IDE_ASCIMP_AUTOSUBHEAD)
///		GETN_OPTION_EVENT(OnChangeAutoSubHeaderLines)
///		GETN_STRLIST(SubHeaderLines, _L("Subheader lines"), "", "|0|1|2|3|4|5|6|7|8|9|10")
///			GETN_ID(IDE_ASCIMP_SUBHEADLINES)
		/// SY 05/24/2005 v8.0240 QA70-6721 ASCIMP_OPTIONS_USE_GETNBOX
		GETN_CHECK(AutoSubHeaderLines, _L("Auto determine subheader lines"), 0) 
			GETN_ID(IDE_ASCIMP_AUTOSUBHEAD)
			GETN_OPTION_EVENT(OnChangeAutoSubHeaderLines)
		GETN_NUM(SubHeaderLines, _L("Subheader lines"), -1)
			GETN_ID(IDE_ASCIMP_SUBHEADLINES)
		/// end ASCIMP_OPTIONS_USE_GETNBOX
		GETN_COMBO(ShortNames, _L("Short Names"), 1, _L("<none>|1|2|3|4|5|6|7|8|9|10"))
			GETN_ID(IDE_ASCIMP_RENAMECOLS)
			GETN_OPTION_SPECIALVALS("0")
		GETN_COMBO(LongNames, _L("Long Names"), -1, _L("<none>|1|2|3|4|5|6|7|8|9|10"))
			GETN_ID(IDE_ASCIMP_LONGNAMES)
			GETN_OPTION_SPECIALVALS("0")
		GETN_COMBO(Units, _L("Units"), -1, _L("<none>|1|2|3|4|5|6|7|8|9|10"))
			GETN_ID(IDE_ASCIMP_UNITS)
			GETN_OPTION_SPECIALVALS("0")
		GETN_COMBO(CommentsFrom, _L("Comments From"), 1, _L("<none>|1|2|3|4|5|6|7|8|9|10"))
			GETN_ID(IDE_ASCIMP_LABEL)
			GETN_OPTION_SPECIALVALS("0")
			GETN_OPTION_EVENT(OnChangeCommentsFrom)
		GETN_COMBO(CommentsTo, _L("Comments To"), -1, "1|2|3|4|5|6|7|8|9|10")
			//GETN_ID(IDE_ASCIMP_MAXLABELS)
		GETN_COMBO(ParamsFrom, _L("Parameters From"), -1, _L("<none>|1|2|3|4|5|6|7|8|9|10"))
			GETN_ID(IDE_ASCIMP_FIRSTPARAMS)
			GETN_OPTION_SPECIALVALS("0")
			GETN_OPTION_EVENT(OnChangeParametersFrom)
		GETN_COMBO(ParamsTo, _L("Parameters To"), -1, "1|2|3|4|5|6|7|8|9|10")
			GETN_ID(IDE_ASCIMP_NUMPARAMS)
		GETN_COMBO(SaveLinesFrom, _L("Save Lines From"), -1, _L("<none>|<all>|1|2|3|4|5|6|7|8|9|10"))
			GETN_ID(IDE_ASCIMP_FIRSTSAVE)
			GETN_OPTION_SPECIALVALS("0")
			GETN_OPTION_EVENT(OnChangeSaveLinesFrom)
		GETN_COMBO(SaveLinesTo, _L("Save Lines To"), -1, _L("<end>|1|2|3|4|5|6|7|8|9|10"))
			//GETN_ID(IDE_ASCIMP_NUMSAVE)
			GETN_OPTION_SPECIALVALS("0")
	GETN_END_BRANCH(HeaderLines)

	GETN_BEGIN_BRANCH(FileName, _L("File Name"))
		GETN_CHECK(FileNameToWksName, _L("Rename worksheet to file name"), 0) GETN_ID(IDE_ASCIMP_RENAMEWKS)
		GETN_CHECK(FileNameToWkbkName, _L("Rename workbook to file name"), 0) //GETN_ID(IDE_ASCIMP_FLAGS)
		GETN_CHECK(AppendFileNameToWkbkComments, _L("Append file name to workbook comments"), 0) //GETN_ID(IDE_ASCIMP_FLAGS)
		GETN_CHECK(AppendFileNameToColComments, _L("Append file name to column comments"), 0) //GETN_ID(IDE_ASCIMP_FLAGS)
		GETN_CHECK(IncludePathWhenAppend, _L("Include path when appending file name"), 0) //GETN_ID(IDE_ASCIMP_FLAGS)
	GETN_END_BRANCH(FileName)

	GETN_BEGIN_BRANCH(Miscellaneous, _L("Miscellaneous"))
		/// EJP 2005-02-28 v8.0198 QA70-7433 IMPORT_CSV_FILES
		GETN_CHECK(RemoveQuotes, _L("Remove quotes from quoted data"), 0)
		/// end IMPORT_CSV_FILES
		GETN_CHECK(SupportLeadingZeros, _L("Support numbers with leading zeros"), 0) GETN_ID(IDE_ASCIMP_LEADZERO)
		GETN_LIST(NonNumericInNumeric, _L("When non-numeric is found in numeric field"), 0, _L("Terminate Import|Read as missing data|Start new worksheet/column|Append to header label")) GETN_ID(IDE_ASCIMP_NONNUMERIC)
		GETN_LIST(ImportMode, _L("Import As"), 0, _L("Auto|Replace Existing Data|Start New Book|Start New Sheet|Start New Columns|Start New Rows")) GETN_ID(IDE_ASCIMP_IMPORTMODE)
	GETN_END_BRANCH(Miscellaneous)

	ASCIMPToGetNTree(tr, ai);
	
	if( GetNBox(tr, _L("ASCII Import Options"), NULL, NULL, NULL, GetWindow()) )
	{
		GetNTreeToASCIMP(ai, tr);
		//dumpai(ai);
		return 0; // user clicked OK
	}
	return 1; // user canceled
}
*/
/// SY 2006-10-04 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET
// Modification as follows:
// 		Turn on all GETN_ID to assign each one an id for tree_copy_values_by_id
/// end XF_THEME_BOOK_AND_SHEET
void construct_ascii_import_options(TreeNode& trGetN, bool bAddUpdateButton)
{
	GETN_USE(trGetN);
	GETN_ID_BRANCH(IDST_DLG_ASCIMP_OPTIONS) 
	//temp code 
	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)		///Joseph 04/25/07 FIX_BUG_SOULD_KEEP_THE_OPEN_STATUS
	if(bAddUpdateButton)
	{
		/// SY 11-17-2004 v8.0164 QA70-6721 ASCIMP_OPTIONS_USE_GETNBOX
		GETN_BUTTON(UpdateOptions, _L("Update Options"), _L("Update Options in Worksheet"))
			GETN_OPTION_EVENT_EX(OnClickUpdateOptions) ///---Sim 10-26-2006 FIX_GETN_IN_XF_EVENT_BUG
		/// end QA70-6721 ASCIMP_OPTIONS_USE_GETNBOX
	}
	
	///---Sim 05-25-2007 MOVE_SPARKLINE_TO_OPTIONS_TREE
	///---Sim 08-06-2007 SUPPORT_SMART_SPARKLINE
	//GETN_CHECK(sparklines, _L("Add Sparkline"), 1)
	GETN_LIST(sparklines, _L("Add Sparklines"), 2, STR_COMBO_SPARKLINE)
	///---END SUPPORT_SMART_SPARKLINE
		GETN_ID(IDE_DISP_IMP_SPARKLINES)
	///---END MOVE_SPARKLINE_TO_OPTIONS_TREE
	
	///---Sim 05-05-2007 ADD_1ST_IMPORT_MODE
	///---Sim 02-12-2007 MAPPING_COMBO_LIST
	string str1stCombo, str1stMapping;
	str1stCombo = getImportModeListString(str1stMapping, IW_FLAG_IMPMODE_REPLACE | IW_FLAG_IMPMODE_NEW_BOOKS \
		 | IW_FLAG_IMPMODE_NEW_SHEETS | IW_FLAG_IMPMODE_NEW_COLS | IW_FLAG_IMPMODE_NEW_ROWS);
	string strCombo, strMapping;
	strCombo = getImportModeListString(strMapping, IW_FLAG_IMPMODE_NEW_BOOKS \
		 | IW_FLAG_IMPMODE_NEW_SHEETS | IW_FLAG_IMPMODE_NEW_COLS | IW_FLAG_IMPMODE_NEW_ROWS);
	///---END MAPPING_COMBO_LIST
	///---END ADD_1ST_IMPORT_MODE
	
	/// Hong 06/20/07 v8.0645 MOVE_IMPMODE_TO_HIGHER_LEVEL_ASDED_BY_JUSTIN
	GETN_LIST(ImpMode, _L("Import Mode"), ASCIMP_MODE_NEW_SHEETS, str1stCombo) GETN_ID(IDE_ASCIMP_IMPORTMODE)
		GETN_ADD_INT_MAP(str1stMapping)
		GETN_OPTION_EVENT_EX(OnChangeImportMode) ///---Sim 08-07-2008 v8.0918 QA80-11969 MULTI_ASC_IMP_SUPPORT_TEMPLATE
	/// end MOVE_IMPMODE_TO_HIGHER_LEVEL_ASDED_BY_JUSTIN
	
	///---Sim 08-07-2008 v8.0918 QA80-11969 MULTI_ASC_IMP_SUPPORT_TEMPLATE
	GETN_BUTTON(Template, _L("Template Name"), "")
		GETN_ID(IDE_DISP_IMP_PAGETEMPLATE)
		GETN_STR_COMBO("...File: ImportFileTemplates");
	///---END v8.0918 QA80-11969 MULTI_ASC_IMP_SUPPORT_TEMPLATE
	
	GETN_BEGIN_BRANCH(FileStruct, _L("File Structure"))
		GETN_LIST(DataStruct, _L("Data Structure"), -1, _L("Fixed column widths|Delimited"))
			GETN_ID(IDE_ASCIMP_DELIMITED)
			GETN_OPTION_EVENT_EX(OnChangeDataStruct) ///---Sim 10-26-2006 FIX_GETN_IN_XF_EVENT_BUG
		/// Hong 08/08/08 v8.0918b FIX_SEL_OTHER_FAIL_ENABLE_OTHER_DELIMITER
		//GETN_LIST(Delimiter, _L("Delimiter"), -1, _L("Unknown|Comma(,)|Tab|Space|Other"))
		GETN_LIST(Delimiter, _L("Delimiter"), -1, _L("Unknown|Comma(,)|Tab|Space|Semicolon|Other"))
		/// end FIX_SEL_OTHER_FAIL_ENABLE_OTHER_DELIMITER
			GETN_ID(IDE_ASCIMP_DELIMCODE)
			GETN_OPTION_EVENT_EX(OnChangeDelimiter) ///---Sim 10-26-2006 FIX_GETN_IN_XF_EVENT_BUG
		GETN_STR(OtherDelimiter, _L("Other Delimiter"), "")
			GETN_ID(IDE_ASCIMP_DELIMCHAR)
		///---Sim 08-07-2007 FIX_IMP_ASC_OPTIONS
		GETN_STR(Delimiters, _L("Delimiters"), "")
			GETN_ID(IDE_ASCIMP_DELIMITERS)
		///---END FIX_IMP_ASC_OPTIONS
		GETN_STR(ColWidths, _L("Column Widths (e.g. 6,3,3,8)"), "")
			GETN_ID(IDE_ASCIMP_COLWIDTHS)
			GETN_OPTION_EVENT_EX(OnChangeColumnWidths) ///---Sim 11-14-2006 FIX_COLUMN_WIDTHS_BUG
		/// EJP 2005-06-27 v8.0258 QA70-5705 ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS
		/// Hong QA80-9972 REMOVE_ORIGIN_SETTING_FOR_NUMERIC_SEPARATOR		
		//GETN_LIST(NumericSeparator, _L("Numeric Separators"), -1, _L("Origin's Setting|1,000.00|1.000,00|1 000,00|1'000.00"))
		GETN_LIST(NumericSeparator, _L("Numeric Separators"), 0, "1,000.00|1.000,00|1 000,00|1'000.00") // Hong 09/22/08 NO_NEED_LOCALIZE
		/// end REMOVE_ORIGIN_SETTING_FOR_NUMERIC_SEPARATOR
			GETN_ID(IDE_ASCIMP_NUMSEP)
			///------ Folger 09/29/09 QA80-14392 IMPASC_FAILS_TO_IMPORT_NUMERIC_DATA_ON_GOS_WITH_DEFAULT_OPTIONS
			octree_set_auto_support(&GETN_CURRENT_SUBNODE, 1);
			///------ End IMPASC_FAILS_TO_IMPORT_NUMERIC_DATA_ON_GOS_WITH_DEFAULT_OPTIONS
		/// end ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS
		///---Sim 01-04-2008 QA12890-P5 IMP_ASC_XF_SUPPORT_SET_CUSTOM_DATE
		GETN_STRLIST(DateFormat, _L("Custom Date Format"), "", "|")
			GETN_ID(IDE_ASCIMP_DATEFORMAT)
		///---END QA12890-P5 IMP_ASC_XF_SUPPORT_SET_CUSTOM_DATE
	GETN_END_BRANCH(FileStruct)

	GETN_BEGIN_BRANCH(Cols, _L("Columns"))
		/// SY 05/24/2005 v8.0240 QA70-6721 ASCIMP_OPTIONS_USE_GETNBOX
		///	GETN_COMBO(NumColumns, _L("Number of columns"), -1, _L("|<unknown>|1|2|3|4|5|6|7|8|9|10"))
		///---Sim 10-26-2006 EDITABLE_COMBOLIST
		//GETN_COMBO(NumColumns, _L("Number of columns"), -1, _L("<unknown>|1|2|3|4|5|6|7|8|9|10"))
		GETN_COMBO(NumCols, _L("Number of Columns"), -1, _L("|0|1|2|3|4|5|6|7|8|9|10"))
		///---END EDITABLE_COMBOLIST
		/// end ASCIMP_OPTIONS_USE_GETNBOX
			GETN_ID(IDE_ASCIMP_NUMCOLUMNS)
			GETN_OPTION_SPECIALVALS("0")
		GETN_CHECK(AutoColTypes, _L("Auto Determine Column Types"), 0)
			GETN_ID(IDE_ASCIMP_AUTOCOLTYPES)
			GETN_OPTION_EVENT_EX(OnChangeAutoColTypes) ///---Sim 10-26-2006 FIX_GETN_IN_XF_EVENT_BUG
		GETN_NUM(MinTestLns, _L("Min Number of Consistent Lines to Determine Data Structure"), -1)
			GETN_ID(IDE_ASCIMP_TESTLINES)
		GETN_NUM(MaxTestLns, _L("Max Number of Consistent Lines to Determine Data Structure"), -1)
			GETN_ID(IDE_ASCIMP_MAXTESTLINES)  //CPY 8/16/06 added this after seeing err
	GETN_END_BRANCH(Cols)
	
	GETN_BEGIN_BRANCH(Hdr, _L("Header Lines"))
		/// SY 05/24/2005 v8.0240 QA70-6721 ASCIMP_OPTIONS_USE_GETNBOX
		///GETN_COMBO(MainHeaderLines, _L("Number of header lines"), 0, "<none>|1|2|3|4|5|6|7|8|9|10")
		/// AW 10/17/06 NEW_IMPASC_OPTIONS
		// keep it same as origin75
		//GETN_COMBO(MainHeaderLines, _L("Number of Main header lines"), -1, _L("<none>|1|2|3|4|5|6|7|8|9|10"))
		GETN_COMBO(MainHdrLns, _L("Number of Main Header Lines (exclude subheader lines)"), -1, _L("|0|1|2|3|4|5|6|7|8|9|10"))
		/// END NEW_IMPASC_OPTIONS
		/// end ASCIMP_OPTIONS_USE_GETNBOX
			GETN_ID(IDE_ASCIMP_HEADLINES)
			GETN_OPTION_SPECIALVALS("0")
			GETN_OPTION_EVENT_EX(OnChangeMainHeaderLines) ///---Sim 10-26-2006 FIX_GETN_IN_XF_EVENT_BUG
///		GETN_CHECK(AutoSubHeaderLines, _L("Auto determine subheader lines"), 0) GETN_ID(IDE_ASCIMP_AUTOSUBHEAD)
///		GETN_OPTION_EVENT(OnChangeAutoSubHeaderLines)
///		GETN_STRLIST(SubHeaderLines, _L("Subheader lines"), "", "|0|1|2|3|4|5|6|7|8|9|10")
///			GETN_ID(IDE_ASCIMP_SUBHEADLINES)
		/// SY 05/24/2005 v8.0240 QA70-6721 ASCIMP_OPTIONS_USE_GETNBOX
		GETN_CHECK(AutoSubHdr, _L("Auto Determine Subheader Lines"), 0) 
			GETN_ID(IDE_ASCIMP_AUTOSUBHEAD)
			GETN_OPTION_EVENT_EX(OnChangeAutoSubHeaderLines) ///---Sim 10-26-2006 FIX_GETN_IN_XF_EVENT_BUG
			
		/// AW 10/17/06 NEW_IMPASC_OPTIONS 
		// CP suggest Add one more option, so the line number start in both way, this checkbox is only enable when AutoSubHeaderLines is TRUE
		// otherise, it is true and disabled, when it is true, will set a new bit in flags of ASCII
		GETN_CHECK(FromBottom, _L("Line Number Start from Bottom"), 0) 
		GETN_ID(IDE_ASCIMP_START_FROM_BOTTOM)
		/// END NEW_IMPASC_OPTIONS	
		
		///---Sim 10-26-2006 CHANGE_NAME
		//GETN_NUM(SubHeaderLines, _L("Subheader lines"), -1)
		/// Hong 09/07/07 v8.698b CONSISTENT_GUI_CONTROL
		//GETN_NUM(SubHdrLns, _L("Number of Subheader Lines"), -1)
		GETN_COMBO(SubHdrLns, _L("Number of Subheader Lines"), -1, _L("|0|1|2|3|4|5|6|7|8|9|10"))
		/// end CONSISTENT_GUI_CONTROL
		///---END CHANGE_NAME
			GETN_ID(IDE_ASCIMP_SUBHEADLINES)
			GETN_OPTION_EVENT_EX(OnChangeSubHeaderLines) ///---Sim 05-29-2007 MAKE_HEADER_LINES_CONSISTENT_WITH_IMP_WIZ
		/// end ASCIMP_OPTIONS_USE_GETNBOX
		///---Sim 10-26-2006 EDITABLE_COMBOLIST
		//GETN_COMBO(ShortNames, _L("Short Names"), -1, _L("<none>|1|2|3|4|5|6|7|8|9|10"))
		GETN_COMBO(SNames, _L("Short Names"), -1, _L("|<none>|1|2|3|4|5|6|7|8|9|10"))
		///---END EDITABLE_COMBOLIST
			GETN_ID(IDE_ASCIMP_RENAMECOLS)
			GETN_OPTION_SPECIALVALS("0")
		///---Sim 10-26-2006 EDITABLE_COMBOLIST
		//GETN_COMBO(LongNames, _L("Long Names"), 1, _L("<none>|1|2|3|4|5|6|7|8|9|10"))
		GETN_COMBO(LNames, _L("Long Names"), 1, _L("|<none>|1|2|3|4|5|6|7|8|9|10"))
		///---END EDITABLE_COMBOLIST
			GETN_ID(IDE_ASCIMP_LONGNAMES)
			GETN_OPTION_SPECIALVALS("0")
		///---Sim 10-26-2006 EDITABLE_COMBOLIST
		//GETN_COMBO(Units, _L("Units"), 2, _L("<none>|1|2|3|4|5|6|7|8|9|10"))
		GETN_COMBO(Units, _L("Units"), 2, _L("|<none>|1|2|3|4|5|6|7|8|9|10"))
		///---END EDITABLE_COMBOLIST
			GETN_ID(IDE_ASCIMP_UNITS)
			GETN_OPTION_SPECIALVALS("0")
		///---Sim 10-26-2006 EDITABLE_COMBOLIST
		//GETN_COMBO(CommentsFrom, _L("Comments From"), 3, _L("<none>|1|2|3|4|5|6|7|8|9|10"))
		GETN_COMBO(CommsFrom, _L("Comments From"), 3, _L("|<none>|1|2|3|4|5|6|7|8|9|10"))
		///---END EDITABLE_COMBOLIST
			GETN_ID(IDE_ASCIMP_LABEL)
			GETN_OPTION_SPECIALVALS("0")
			GETN_OPTION_EVENT_EX(OnChangeCommentsFrom)  ///---Sim 10-26-2006 FIX_GETN_IN_XF_EVENT_BUG
		///---Sim 10-26-2006 EDITABLE_COMBOLIST
		//GETN_COMBO(CommentsTo, _L("Comments To"), -1, "1|2|3|4|5|6|7|8|9|10")
		GETN_COMBO(CommsTo, _L("Comments To"), -1, "|1|2|3|4|5|6|7|8|9|10")
		///---END EDITABLE_COMBOLIST
			GETN_ID(IDE_ASCIMP_MAXLABELS)
		///---Sim 10-26-2006 EDITABLE_COMBOLIST
		//GETN_COMBO(ParamsFrom, _L("Parameters From"), -1, _L("<none>|1|2|3|4|5|6|7|8|9|10"))
		GETN_COMBO(ParamsFrom, _L("System Parameters From"), -1, _L("|<none>|1|2|3|4|5|6|7|8|9|10"))
		///---END EDITABLE_COMBOLIST
			GETN_ID(IDE_ASCIMP_FIRSTPARAMS)
			GETN_OPTION_SPECIALVALS("0")
			GETN_OPTION_EVENT_EX(OnChangeParametersFrom)  ///---Sim 10-26-2006 FIX_GETN_IN_XF_EVENT_BUG
		///---Sim 10-26-2006 EDITABLE_COMBOLIST
		//GETN_COMBO(ParamsTo, _L("Parameters To"), -1, "1|2|3|4|5|6|7|8|9|10")
		GETN_COMBO(ParamsTo, _L("System Parameters To"), -1, "|1|2|3|4|5|6|7|8|9|10")
		///---END EDITABLE_COMBOLIST
			GETN_ID(IDE_ASCIMP_NUMPARAMS)
		///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
		GETN_COMBO(UParamsFrom, _L("User Parameters From"), -1, _L("|<none>|1|2|3|4|5|6|7|8|9|10"))
			GETN_ID(IDE_ASCIMP_FIRSTUSERPARAMS)
			GETN_OPTION_SPECIALVALS("0")
			GETN_OPTION_EVENT_EX(OnChangeUserParametersFrom)
		GETN_COMBO(UParamsTo, _L("User Parameters To"), -1, "|1|2|3|4|5|6|7|8|9|10")
			GETN_ID(IDE_ASCIMP_NUMUSERPARAMS)
		///---END SUPPORT_USER_PARAMETER
		GETN_COMBO(SaveLnsFrom, _L("Save Lines From"), -1, _L("<none>|<all>|1|2|3|4|5|6|7|8|9|10"))
			GETN_ID(IDE_ASCIMP_FIRSTSAVE)
			GETN_OPTION_SPECIALVALS("0")
			GETN_OPTION_EVENT_EX(OnChangeSaveLinesFrom) ///---Sim 10-26-2006 FIX_GETN_IN_XF_EVENT_BUG
		GETN_COMBO(SaveLnsTo, _L("Save Lines To"), -1, _L("<end>|1|2|3|4|5|6|7|8|9|10"))
			GETN_ID(IDE_ASCIMP_NUMSAVE)
			GETN_OPTION_SPECIALVALS("0")
	GETN_END_BRANCH(Hdr)

	/// Hong 03/11/10 QA80-15192 SUPPORT_EDIT_BINARY_FILTER_CREATED_BY_IMPWIZ
	/*
	/// AW 10/06/06 MORE_ON_XF_THEME_BOOK_AND_SHEET
	// FileName node is used in trGUI, and we use hard codes to set, so there is a problem.
	//GETN_BEGIN_BRANCH(FileName, _L("File Name"))
	/// Hong 04/16/08 QA80-11397 CENTRALIZE_WITH_BETTER_LABEL_OF_RENAME_OPTIONS
	//GETN_BEGIN_BRANCH(Names, _L("File Name"))
	GETN_BEGIN_BRANCH(Names, STR_LBL_RENAME_OPTIONS)
	/// end CENTRALIZE_WITH_BETTER_LABEL_OF_RENAME_OPTIONS
	/// END MORE_ON_XF_THEME_BOOK_AND_SHEET
		///---Sim 02-12-2007 ADD_AUTO_RENAME
		///---Sim 03-31-2008 QA80-11351 DEFAULT_UNCHECK_AUTO_RENAME
		//GETN_CHECK(AutoNames, _L("Auto Rename"), 1) GETN_ID(IDE_DISP_IMP_AUTO_RENAME) 
		/// Hong 04/16/08 QA80-11397 CENTRALIZE_WITH_BETTER_LABEL_OF_RENAME_OPTIONS
		//GETN_CHECK(AutoNames, _L("Auto Rename"), 0) GETN_ID(IDE_DISP_IMP_AUTO_RENAME)
		GETN_CHECK(AutoNames, STR_LBL_AUTO_RENAME, 0) GETN_ID(IDE_DISP_IMP_AUTO_RENAME)
		/// end CENTRALIZE_WITH_BETTER_LABEL_OF_RENAME_OPTIONS
		///---END QA80-11351 DEFAULT_UNCHECK_AUTO_RENAME
			GETN_OPTION_EVENT_EX(OnChangeRenameOptions)
		///---END ADD_AUTO_RENAME
		GETN_CHECK(FNameToSht, STR_LBL_RENAME_SHEET, 0) GETN_ID(IDE_ASCIMP_RENAMEWKS)
		/// Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
			GETN_OPTION_EVENT_EX(OnChangeRenameOptions)
		/// Hong 03/06/07 CHANGE_TRIM_FNAME_OFFSET_FROM_ZERO_TO_ONE
		//GETN_NUM(WksTrimFileNameFrom, _L("Trim Filename From"), 0) GETN_ID(IDE_DISPIMP_RENAMEWKSTRIMFNAMEFROM)
		//GETN_NUM(WksTrimFileNameTo, _L("Trim Filename To"), -1) GETN_ID(IDE_DISPIMP_RENAMEWKSTRIMFNAMETO)
		GETN_NUM(FNameToShtFrom, STR_LBL_TRIM_FROM, 1) GETN_ID(IDE_DISPIMP_RENAMEWKSTRIMFNAMEFROM)
		GETN_NUM(FNameToShtTo, STR_LBL_TRIM_TO, 0) GETN_ID(IDE_DISPIMP_RENAMEWKSTRIMFNAMETO)
		/// end CHANGE_TRIM_FNAME_OFFSET_FROM_ZERO_TO_ONE
		/// end MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
///------ AW 10/05/06 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET
//		GETN_CHECK(FileNameToWkbkName, _L("Rename workbook to file name"), 0) GETN_ID(IDE_ASCIMP_FLAGS)
//		GETN_CHECK(AppendFileNameToWkbkComments, _L("Append file name to workbook comments"), 0) GETN_ID(IDE_ASCIMP_FLAGS)
//		GETN_CHECK(AppendFileNameToColComments, _L("Append file name to column comments"), 0) GETN_ID(IDE_ASCIMP_FLAGS)
//		GETN_CHECK(IncludePathWhenAppend, _L("Include path when appending file name"), 0) GETN_ID(IDE_ASCIMP_FLAGS)
		GETN_CHECK(FNameToBk, STR_LBL_RENAME_BOOK, 0) GETN_ID(IDE_ASCIMP_FILENAME2WKS)
		///---Sim 03-06-2007 MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
			GETN_OPTION_EVENT_EX(OnChangeRenameOptions)
		/// Hong 03/06/07 CHANGE_TRIM_FNAME_OFFSET_FROM_ZERO_TO_ONE
		//GETN_NUM(WkbkTrimFileNameFrom, _L("Trim Filename From"), 0) GETN_ID(IDE_DISPIMP_RENAMEWKBKTRIMFNAMEFROM)
		//GETN_NUM(WkbkTrimFileNameTo, _L("Trim Filename To"), -1) GETN_ID(IDE_DISPIMP_RENAMEWKBKTRIMFNAMETO)
		GETN_NUM(FNameToBkFrom, STR_LBL_TRIM_FROM, 1) GETN_ID(IDE_DISPIMP_RENAMEWKBKTRIMFNAMEFROM)
		GETN_NUM(FNameToBkTo, STR_LBL_TRIM_TO, 0) GETN_ID(IDE_DISPIMP_RENAMEWKBKTRIMFNAMETO)
		/// end CHANGE_TRIM_FNAME_OFFSET_FROM_ZERO_TO_ONE
		///---END MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
		GETN_CHECK(FNameToBkLnOnly, STR_LBL_LONG_NAME_ONLY, 0) GETN_ID(IDE_ASCIMP_WKBKLNONLY) ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		GETN_CHECK(FPathToBk, STR_LBL_BOOK_INCLUDE_PATH, 0) GETN_ID(IDE_ASCIMP_ADDPATH4WKBK) ///---Sim 03-02-2007 ADD_FILE_PATH_OPTION_FOR_RENAME_WKBK
		GETN_CHECK(FNameToBkComm, STR_LBL_APPEND_FNAME_TO_BKCMT, 0) GETN_ID(IDE_ASCIMP_FILENAME2WKSCOMMENT)
			GETN_OPTION_EVENT_EX(OnChangeRenameOptions)///---Sim 03-13-2007 CENTRALIZE_FILE_NAME_OPTIONS_ENABLE
		GETN_CHECK(FNameToColComm, STR_LBL_APPEND_FNAME_TO_COLCMT, 0) GETN_ID(IDE_ASCIMP_FILENAME2COLCOMMENT)
			GETN_OPTION_EVENT_EX(OnChangeRenameOptions)///---Sim 03-13-2007 CENTRALIZE_FILE_NAME_OPTIONS_ENABLE
		GETN_CHECK(FPathToComm, STR_LBL_APPEND_PATH_TO_FNAME, 0) GETN_ID(IDE_ASCIMP_ADDPATH)
///------ END XF_THEME_BOOK_AND_SHEET
	/// AW 10/06/06 MORE_ON_XF_THEME_BOOK_AND_SHEET
	// FileName node is used in trGUI, and we use hard codes to set, so there is a problem.
	//GETN_END_BRANCH(FileName)
	GETN_END_BRANCH(Names)
	/// END MORE_ON_XF_THEME_BOOK_AND_SHEET
	
	/// Hong 03/02/07 QA80-9015 ADD_PARTIAL_IMPORT_OPTION
	GETN_BEGIN_BRANCH(PartImp, STR_LBL_PARTIAL_IMPORT)
		GETN_CHECK(Partial, STR_LBL_PARTIAL_IMPORT, 0) GETN_ID(IDE_ASCIMP_PARTIAL) 
			GETN_OPTION_EVENT_EX(OnChangePartialImport)
		GETN_NUM(FirstCol, _L("From Column"), 0) GETN_ID(IDE_ASCIMP_PARTIALC1)
		GETN_NUM(LastCol, _L("To Column"), -1) GETN_ID(IDE_ASCIMP_PARTIALC2)
		GETN_NUM(FirstRow, _L("From Row"), 0) GETN_ID(IDE_ASCIMP_PARTIALR1)
		GETN_NUM(ReadRows, _L("Read Rows"), 1) GETN_ID(IDE_ASCIMP_READROWS)
		GETN_NUM(SkipRows, _L("Skip Data Rows"), 0) GETN_ID(IDE_ASCIMP_SKIPROWS)
			GETN_OPTION_EVENT_EX(OnChangeSkipRow)
		GETN_NUM(LastRow, _L("To Row"), -1) GETN_ID(IDE_ASCIMP_PARTIALR2)
	GETN_END_BRANCH(PartImp)
	/// end ADD_PARTIAL_IMPORT_OPTION
	*/
	_construct_rename_options(GETN_CURRENT_NODE);
	_construct_partial_options(GETN_CURRENT_NODE);
	/// end SUPPORT_EDIT_BINARY_FILTER_CREATED_BY_IMPWIZ

	GETN_BEGIN_BRANCH(Miscellaneous, _L("Miscellaneous"))
		//GETN_OPTION_BRANCH(GETNBRANCH_OPEN) /// Hong 06/20/07 v8.0645 MAX_JUSINT_ASK_NOT_DEFAULT_EXPAND_THIS_BRANCH
		/// EJP 2005-02-28 v8.0198 QA70-7433 IMPORT_CSV_FILES
		/// Hong 03/23/07 v8.0589b IMPASC_ADD_TEXT_QUALIFIER_OPTION
		//GETN_CHECK(RemoveQuotes, _L("Remove Quotes from Quoted Data"), 0)
		GETN_LIST(Qualifier, _L("Text Qualifier"), 0, "NONE|\"|'")	GETN_ID(IDE_ASCIMP_QUOTECHAR)
			GETN_OPTION_EVENT_EX(OnChangetTextQualifier)
		GETN_CHECK(RemoveQuotes, _L("Remove Text Qualifier from Quoted Data"), 1) ///---Sim 05-29-2007 CHANGE_DEFAULT_VALUE
		/// end IMPASC_ADD_TEXT_QUALIFIER_OPTION
		GETN_ID(IDE_ASCIMP_REMOVE_QUOTES)  /// AW 10/06/06 MORE_ON_XF_THEME_BOOK_AND_SHEET
		/// end IMPORT_CSV_FILES
		GETN_CHECK(LeadingZeros, _L("Remove Leading Zeros from Numbers"), 0) GETN_ID(IDE_ASCIMP_LEADZERO)
		///---Sim 03-17-2007 CHANGE_LABEL_OF_NON_NUMERIC_DATA
		//GETN_LIST(NonNumericInNumeric, _L("When Non-numeric is Found in Numeric Field"), 0, _L("Terminate Import|Read as missing data|Start new worksheet/column|Append to header label")) GETN_ID(IDE_ASCIMP_NONNUMERIC)
		GETN_LIST(NonNum, _L("When Non-numeric is Found in Numeric Field"), 0, _L("Terminate Import|Read as Text|Start New Worksheet|Start New Column")) GETN_ID(IDE_ASCIMP_NONNUMERIC)
		///---END CHANGE_LABEL_OF_NON_NUMERIC_DATA
		/// Hong 12/05/07 v8.0761 IMPASC_ALLOW_IMPORT_ALL_TEXT_DATA
		GETN_CHECK(AllowAllText, _L("Allow Import All Text Data"), 0) GETN_ID(IDE_ASCIMP_ALLOWALLTEXT)
		/// end IMPASC_ALLOW_IMPORT_ALL_TEXT_DATA
		/// Hong 08/31/09 QA80-12899 IMP_WIZ_SUPPORT_KEEP_COL_FMTS_IN_TEMPLATE
		GETN_CHECK(KeepDestColFmt, _L("Keep Target Column Format"), 0) GETN_ID(IDE_ASCIMP_KEEP_DEST_COL_FMT)
		/// end IMP_WIZ_SUPPORT_KEEP_COL_FMTS_IN_TEMPLATE
		
		/// Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
		GETN_CHECK(SaveImpInfo, _L("Save File Info. in Workbook"), 1) GETN_ID(IDE_ASCIMP_SAVE_IMP_INFO)
		/// end ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
		
		///---Sim 05-29-2007 ONLY_ONE_IMPORT_MODE_SAME_AS_IMP_WIZ
		/*
		///---Sim 05-05-2007 ADD_1ST_IMPORT_MODE
		GETN_LIST(1stImportMode, _L("1st File Import Mode"), ASCIMP_MODE_REPLACE_DATA, str1stCombo) GETN_ID(IDE_DISPIMP_1STMODE)
			GETN_ADD_INT_MAP(str1stMapping)
		///---END ADD_1ST_IMPORT_MODE
		///---Sim 02-12-2007 MAPPING_COMBO_LIST
		//GETN_LIST(ImportMode, _L("Import As"), 0, _L("Auto|Replace Existing Data|Start New Book|Start New Sheet|Start New Columns|Start New Rows")) GETN_ID(IDE_ASCIMP_IMPORTMODE)
		GETN_LIST(ImportMode, _L("Multi-File (except 1st) Import Mode"), ASCIMP_MODE_NEW_SHEETS, strCombo) GETN_ID(IDE_ASCIMP_IMPORTMODE)
			GETN_ADD_INT_MAP(strMapping)
		///---END MAPPING_COMBO_LIST
		*/
		/// Hong 06/20/07 v8.0645 MOVE_IMPMODE_TO_HIGHER_LEVEL_ASDED_BY_JUSTIN
		//GETN_LIST(ImpMode, _L("Import Mode"), ASCIMP_MODE_NEW_SHEETS, str1stCombo) GETN_ID(IDE_ASCIMP_IMPORTMODE)
		//	GETN_ADD_INT_MAP(str1stMapping)
		/// end MOVE_IMPMODE_TO_HIGHER_LEVEL_ASDED_BY_JUSTIN
		///---END ONLY_ONE_IMPORT_MODE_SAME_AS_IMP_WIZ
	GETN_END_BRANCH(Miscellaneous)
	
	ASCIMP ai;
	///---Sim 04-06-2007 MAKE_IMPWIZ_AND_ASCXF_ARE_CONSISTENT
	//okoc_init_ASCIMP(&ai);
	initASCIMP(ai);
	///---END MAKE_IMPWIZ_AND_ASCXF_ARE_CONSISTENT
	ai.iMode = ASCIMP_MODE_REPLACE_DATA; ///---Sim 07-11-2007 CHANGE_ASCII_IMPORT_DEFAULT_MODE
	ASCIMPToGetNTree(trGetN, ai);
	/// Hong 08/12/09 IMPASC_DEFAULT_HEADER_COMMENT_TO_START_FROM_3RD_LINE_SUGGESTED_BY_EASWAR
	trGetN.Hdr.CommsFrom.nVal = 3;
	/// end Hong 08/12/09 IMPASC_DEFAULT_HEADER_COMMENT_TO_START_FROM_3RD_LINE_SUGGESTED_BY_EASWAR
}

int DoAsciiImportOptionsDialog(ASCIMP& ai)
{
	/// EJP 2006-01-17 v8.0358 UNIQUE_ID_FOR_HELP_WITH_GETN_BOX
	///GETN_TREE(tr)
	GETN_TREE(tr) //GETN_ID_BRANCH(IDST_DLG_ASCIMP_OPTIONS)  AW CP said no need this
	/// end UNIQUE_ID_FOR_HELP_WITH_GETN_BOX

	GETN_OPTION_GRIDLINE(flexGridRaisedVert) // Option to add vertical divider line
	GETN_OPTION_EDIT_ALIGN("0|0|0") // left align checkbox|numbers|strings

	construct_ascii_import_options(tr, true);
	ASCIMPToGetNTree(tr, ai);
	
	if( GetNBox(tr, _L("ASCII Import Options"), NULL, NULL, NULL, GetWindow()) )
	{
		GetNTreeToASCIMP(ai, tr);
		//dumpai(ai);
		return 0; // user clicked OK
	}
	return 1; // user canceled
}
/// END ADD_IMPASC


/// AW 10/17/06 NEW_IMPASC_OPTIONS			
static int  GetMinValue(int* parrLineNumer, int nItemCount)
{
	if ( 0 == nItemCount )
		return 0;
	int nMin = *parrLineNumer++;
	for ( int ii = 1; ii < nItemCount; ii++, parrLineNumer++ )
	{
		if ( nMin > *parrLineNumer )
			nMin = *parrLineNumer;	
	}
	return nMin;
}
/// END NEW_IMPASC_OPTIONS

/// SY 2006-10-03 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET
// Modification as follows:
// 		Remove #ifdef ASCIMP_OPTIONS_USE_GETN_ID
//		Update trnTarget if subnode exists. Used to return false if subnode invalid.
/// end XF_THEME_BOOK_AND_SHEET

///------ Folger 09/29/09 QA80-14392 IMPASC_FAILS_TO_IMPORT_NUMERIC_DATA_ON_GOS_WITH_DEFAULT_OPTIONS
static	int		_check_get_numeric_separator_from_ai(ASCIMP& ai)
{
	if ( NF_IS_AMERICAN > ai.nNumSep || NF_IS_UNKNOWN <= ai.nNumSep )
		return 0;

	return ai.nNumSep - 1;
}
///------ End IMPASC_FAILS_TO_IMPORT_NUMERIC_DATA_ON_GOS_WITH_DEFAULT_OPTIONS

bool ASCIMPToGetNTree(TreeNode& trnTarget, ASCIMP& aiSource)
{
	Tree trAI;
	trAI = aiSource;
	if( tree_copy_values_by_id(trAI, trnTarget) <= 0 )
		return false;
	
	int i;

	// Values not be copied by DataID
	TreeNode trn;
	
	trn = trnTarget.FileStruct;
	if( trn )
	{
		///------ Folger 09/29/09 QA80-14392 IMPASC_FAILS_TO_IMPORT_NUMERIC_DATA_ON_GOS_WITH_DEFAULT_OPTIONS
// 		/// Hong QA80-9972 REMOVE_ORIGIN_SETTING_FOR_NUMERIC_SEPARATOR
// 		//if( NF_IS_ORIGIN == aiSource.nNumSep )
// 		//	trn.NumericSeparator.nVal = 0;
// 		//else
// 		//	trn.NumericSeparator.nVal = aiSource.nNumSep;
// 		if ( NF_IS_AMERICAN > aiSource.nNumSep || NF_IS_UNKNOWN <= aiSource.nNumSep )
// 			trn.NumericSeparator.nVal = 0;
// 		else
// 			trn.NumericSeparator.nVal = aiSource.nNumSep - 1;
// 		/// end REMOVE_ORIGIN_SETTING_FOR_NUMERIC_SEPARATOR
		trn.NumericSeparator.nVal = _check_get_numeric_separator_from_ai(aiSource);
		///------ End IMPASC_FAILS_TO_IMPORT_NUMERIC_DATA_ON_GOS_WITH_DEFAULT_OPTIONS
		
		trnTarget.FileStruct.OtherDelimiter.strVal.Format("%c", aiSource.cChar);
				
		///Kyle 01/04/2009 QA70-12890-P4 CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT
		trn.DateFormat.strVal = EMPTY2NONE(trn.DateFormat.strVal);
		///End CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT
	}	
	///////////////////////////////////////////////////////
	// Header Lines
	///////////////////////////////////////////////////////
	trn = trnTarget.Hdr;
	if( trn )
	{
		/// AW 10/17/06 NEW_IMPASC_OPTIONS
		/*
		// Main header lines is copied by ID
		///trn.MainHeaderLines.nVal
		trn.MainHeaderLines.nVal += aiSource.iSubHeaderLines;
	
		if( aiSource.iRenameCols <= 0 )
			trn.ShortNames.nVal = 0; // 0 = none
		else
		{
			/// SY 05/24/2005 v8.0240 QA70-6721 ASCIMP_OPTIONS_USE_GETNBOX
			///	trn.ShortNames.nVal = trn.MainHeaderLines.nVal + 1 - aiSource.iRenameCols;
			if( trn.MainHeaderLines.nVal )
				trn.ShortNames.nVal = trn.MainHeaderLines.nVal + 1 - aiSource.iRenameCols;
			else
				trn.ShortNames.nVal = aiSource.iRenameCols;
			/// end ASCIMP_OPTIONS_USE_GETNBOX
		}
	
		// Long Names and Units are copied by ID, but need to be incremented
		// because internally -1 = none and 0 = first line.
		trnTarget.Hdr.LNames.nVal++;
		trnTarget.Hdr.Units.nVal++;
	
		// Comments
		if( aiSource.iLabels <= 0 )
		{
			//trn.CommentsFrom.nVal = 0; // 0 = none
			//trn.CommsTo.nVal = 0;
		}
		else
		{
			// Comments From is copied by ID, but now need to offset by header lines
			// because Comments must be in sub-header lines.
			trn.CommentsFrom.nVal += aiSource.iHeaderLines;
			trn.CommentsTo.nVal = trn.CommentsFrom.nVal + aiSource.iMaxLabels - 1;
		}
		
		
		// Parameters
		trn.ParamsFrom.nVal++;
		trn.ParamsTo.nVal += trn.ParamsFrom.nVal - 1;
	
		// Save Lines
		trn.SaveLinesFrom.nVal++;
		trn.SaveLinesTo.nVal += trn.SaveLinesFrom.nVal;
		*/
		if ( !aiSource.iAutoSubHeaderLines )
		{
			int arrLineNumer[SUBHEADERMAX];  
			int iHeaderLines = aiSource.iHeaderLines + aiSource.iSubHeaderLines;
			int nItemCount = 0;
			
			///---Sim 04-28-2007 FIX_CONVERT_FILTER_TO_GETN
			if ( aiSource.iLabels > 0 )
			{
				//trn.CommentsFrom.nVal = aiSource.iHeaderLines + 1;
				trn.CommsFrom.nVal += aiSource.iHeaderLines;
				arrLineNumer[nItemCount++] = trn.CommsFrom.nVal;
			}
			else
				trn.CommsFrom.nVal = 0;
			///---END FIX_CONVERT_FILTER_TO_GETN
			///---Sim 04-28-2007 FIX_CONVERT_FILTER_TO_GETN
			//if( aiSource.iRenameCols > 0 ) 
			if( aiSource.iRenameCols > 0 && iHeaderLines >= aiSource.iRenameCols ) 
			///---END FIX_CONVERT_FILTER_TO_GETN
			{
				trn.SNames.nVal = iHeaderLines - aiSource.iRenameCols + 1;
				arrLineNumer[nItemCount++] = trn.SNames.nVal;
			}
			else
				trn.SNames.nVal = 0;
			if ( trn.LNames.nVal >= 0 )
			{
				arrLineNumer[nItemCount++] = ++trn.LNames.nVal;	
			}
			else
				trn.LNames.nVal = 0;	
			if ( trn.Units.nVal >= 0 )
				arrLineNumer[nItemCount++] = ++trn.Units.nVal;	
			else
				trn.Units.nVal = 0;	
			
			if ( trn.ParamsFrom.nVal >= 0 )
				arrLineNumer[nItemCount++] = ++trn.ParamsFrom.nVal;	
			else
				trn.ParamsFrom.nVal = 0;

			///---Sim 01-26-2007 SUPPORT_USER_PARAMETER			
			if ( trn.UParamsFrom.nVal >= 0 )
				arrLineNumer[nItemCount++] = ++trn.UParamsFrom.nVal;	
			else
				trn.UParamsFrom.nVal = 0;
			///---END SUPPORT_USER_PARAMETER			
			
			///---Sim 08-07-2007 FIX_IMP_ASC_OPTIONS
			//trn.MainHdrLns.nVal = GetMinValue(arrLineNumer, nItemCount) - 1;
			int nLowPos = GetMinValue(arrLineNumer, nItemCount);
			if ( nLowPos > 0 )
				trn.MainHdrLns.nVal = nLowPos - 1;
			else
				trn.MainHdrLns.nVal = iHeaderLines;
			///---END FIX_IMP_ASC_OPTIONS
			trn.SubHdrLns.nVal = iHeaderLines - trn.MainHdrLns.nVal;

			int offset = trn.MainHdrLns.nVal;
			
			if ( trn.SNames.nVal > offset )
				trn.SNames.nVal -= offset;
			
			if ( trn.LNames.nVal > offset )
				trn.LNames.nVal -= offset;
			if ( trn.Units.nVal > offset )
				trn.Units.nVal -= offset;
			
			if ( trn.CommsFrom.nVal > offset )
			{
				trn.CommsFrom.nVal -= offset;
				trn.CommsTo.nVal = trn.CommsFrom.nVal + aiSource.iMaxLabels - 1;
			}
			else
				trn.CommsTo.nVal = 0;
				
			if ( trn.ParamsFrom.nVal > offset )
			{
				trn.ParamsFrom.nVal -= offset;
				trn.ParamsTo.nVal += trn.ParamsFrom.nVal - 1;
			}
			else
				trn.ParamsTo.nVal = 0;
			
			///---Sim 01-26-2007 SUPPORT_USER_PARAMETER			
			if ( trn.UParamsFrom.nVal > offset )
			{
				trn.UParamsFrom.nVal -= offset;
				trn.UParamsTo.nVal += trn.UParamsFrom.nVal - 1;
			}
			else
				trn.UParamsTo.nVal = 0;
			///---END SUPPORT_USER_PARAMETER	
			
//			trn.SaveLinesFrom.nVal++;
//			trn.SaveLinesTo.nVal += trn.SaveLinesFrom.nVal;
			
		}
		else
		{
			if ( aiSource.iLabels )
				trn.CommsTo.nVal += trn.CommsFrom.nVal - 1;
			
			///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
			if ( trn.UParamsFrom.nVal <= 0 )
			{
				trn.UParamsFrom.nVal = 0;
				trn.UParamsTo.nVal = 0;
			}
			else
				trn.UParamsTo.nVal += trn.UParamsFrom.nVal - 1;
			///---END SUPPORT_USER_PARAMETER
			
			if ( trn.ParamsFrom.nVal <= 0 )
			{
				trn.ParamsFrom.nVal = 0;
				trn.ParamsTo.nVal = 0;
			}
			else
				trn.ParamsTo.nVal += trn.ParamsFrom.nVal - 1;
			
			
			if ( trn.SNames.nVal < 0 )
				trn.SNames.nVal = 0;
			
			if ( trn.LNames.nVal < 0 )
				trn.LNames.nVal = 0;
			
			if ( trn.Units.nVal < 0 )
				trn.Units.nVal = 0;
		}
		trn.FromBottom.nVal = aiSource.flags & AI_FLAG_START_FROM_BOTTOM;
		/// END  NEW_IMPASC_OPTIONS
	}
	
	
	/// AW 10/06/06 MORE_ON_XF_THEME_BOOK_AND_SHEET
	// FileName node is used in trGUI, and we use hard codes to set, so there is a problem.
	//trn = trnTarget.FileName;
	trn = trnTarget.Names;
	/// END MORE_ON_XF_THEME_BOOK_AND_SHEET

	if( trn )
	{
		/// Hong 03/11/10 QA80-15192 SUPPORT_EDIT_BINARY_FILTER_CREATED_BY_IMPWIZ
		//trn.FNameToSht.nVal = aiSource.iRenameWks;
		//trn.FNameToBk.nVal = (aiSource.flags & AI_FLAG_FNAME_TO_WKBK_NAME) ? 1 : 0;
		//trn.FNameToBkLnOnly.nVal = (aiSource.flags & AI_FLAG_FNAME_TO_WKBK_LONG_NAME_ONLY) ? 1 : 0; ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		//trn.FPathToBk.nVal = (aiSource.flags & AI_FLAG_REMOVE_FNAME_PATH_FOR_WKBK_NAME) ? 0 : 1; ///---Sim 03-02-2007 ADD_FILE_PATH_OPTION_FOR_RENAME_WKBK
		//trn.FNameToBkComm.nVal = (aiSource.flags & AI_FLAG_FNAME_TO_WKBK_COMMENTS) ? 1 : 0;
		//trn.FNameToColComm.nVal = (aiSource.flags & AI_FLAG_FNAME_TO_COL_COMMENTS) ? 1 : 0;
		//trn.FPathToComm.nVal = (aiSource.flags & AI_FLAG_REMOVE_FNAME_PATH) ? 0 : 1;
		_set_rename_options(trn, aiSource.iRenameWks, aiSource.flags);
		/// end SUPPORT_EDIT_BINARY_FILTER_CREATED_BY_IMPWIZ
	}
	
	///////////////////////////////////////////////////////
	// Partial Import
	///////////////////////////////////////////////////////
	/// Hong 03/02/07 QA80-9015 ADD_PARTIAL_IMPORT_OPTION
	trn = trnTarget.PartImp;
	if( trn )
	{
		trn.FirstCol.nVal++;
		trn.LastCol.nVal++;
		trn.FirstRow.nVal++;
		trn.LastRow.nVal++;
	}
	/// end ADD_PARTIAL_IMPORT_OPTION
	
	trn = trnTarget.Miscellaneous;
	if( trn )
	{
		//trn.ImportMode.nVal = _GetListIndexFromImportMode(aiSource.iMode); ///---Sim 02-12-2007 MAPPING_COMBO_LIST remove
		
		/// Hong 03/23/07 v8.0589b IMPASC_ADD_TEXT_QUALIFIER_OPTION
		// "NONE|\"|\'"
		if( '\0' == aiSource.cQuote )
		{
			trn.Qualifier.nVal = 0;
		}
		else if( '\"' == aiSource.cQuote )
		{
			trn.Qualifier.nVal = 1;
		}
		else
		{
			trn.Qualifier.nVal = 2;
		}
		trn.RemoveQuotes.Enable = trn.Qualifier.nVal;
		/// end IMPASC_ADD_TEXT_QUALIFIER_OPTION
		
		/// EJP 2005-06-27 v8.0258 QA70-7433 IMPORT_CSV_FILES
		trn.RemoveQuotes.nVal = (aiSource.flags & AI_FLAG_REMOVE_QUOTES ? 1 : 0);
		/// end IMPORT_CSV_FILES
		/// Hong 08/31/09 QA80-12899 IMP_WIZ_SUPPORT_KEEP_COL_FMTS_IN_TEMPLATE
		if ( trn.KeepDestColFmt )
			trn.KeepDestColFmt.nVal = (AI_FLAG_KEEP_TARGET_SHEET_COL_FORMAT & aiSource.flags) ? 1 : 0;
		/// end IMP_WIZ_SUPPORT_KEEP_COL_FMTS_IN_TEMPLATE
		/// Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
		if ( trn.SaveImpInfo )
			trn.SaveImpInfo.nVal = (AI_FLAG_NO_IMPORT_INFO_TO_PAGE & aiSource.flags) ? 0 : 1;
		/// end /// Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
	}
	return true;
}

/// SY 2006-10-03 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET
// Modification as follows:
// 		Remove #ifdef ASCIMP_OPTIONS_USE_GETN_ID
//		Update trnTarget if subnode exists. Used to return false if subnode invalid.
/// end XF_THEME_BOOK_AND_SHEET
/// AW 08/16/06 ADD_IMPASC
//static bool GetNTreeToASCIMP(ASCIMP& aiTarget, TreeNode& trnSource)
bool GetNTreeToASCIMP(ASCIMP& aiTarget, TreeNode& trnSource)
/// END ADD_IMPASC
{
	Tree trAI;
	trAI = aiTarget;
	if( tree_copy_values_by_id(trnSource, trAI) <= 0 )
		return false;
	aiTarget = trAI;

	// Values not copied by DataID
	TreeNode trn;
	
	trn = trnSource.FileStruct;
	if( trn )
	{
		/// Hong QA80-9972 REMOVE_ORIGIN_SETTING_FOR_NUMERIC_SEPARATOR
		//if( 0 == trn.NumericSeparator.nVal )
		//	aiTarget.nNumSep = NF_IS_ORIGIN;
		//else
		//	aiTarget.nNumSep = trn.NumericSeparator.nVal;
		aiTarget.nNumSep = trn.NumericSeparator.nVal + 1;
		/// end REMOVE_ORIGIN_SETTING_FOR_NUMERIC_SEPARATOR
		if( !trnSource.FileStruct.OtherDelimiter.strVal.IsEmpty() )
			aiTarget.cChar = trnSource.FileStruct.OtherDelimiter.strVal.GetAt(0);
		
		/// Hong 02/09/10 QA80-14079-P6 FIX_IMPASC_SINGLE_CHAR_IN_DELIMITERS_FAIL_TO_WORK
	#ifdef		__FIX_DELIMITERS_FAIL_WORK_WHEN_SIGNLE_CHAR__
		if ( ASCIMP_DELIM_UNKNOWN == trnSource.FileStruct.Delimiter.nVal && 1 == lstrlen(trnSource.FileStruct.Delimiters.strVal) )
		{
			aiTarget.iDelimiter = ASCIMP_DELIM_OTHER;
			aiTarget.cChar = trnSource.FileStruct.Delimiters.strVal.GetAt(0);
			aiTarget.cDelimiters[0] = '\0';
		}
	#endif		//__FIX_DELIMITERS_FAIL_WORK_WHEN_SIGNLE_CHAR__
		/// end FIX_IMPASC_SINGLE_CHAR_IN_DELIMITERS_FAIL_TO_WORK
		
		///Kyle 01/04/2009 QA70-12890-P4 CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT
		strncpy(aiTarget.szDateFormat, NONE2EMPTY(aiTarget.szDateFormat), MAX_SIZE_CUSTOM_FORMAT);
		///End CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT
	}
	
	///////////////////////////////////////////////////////
	// Header Lines
	///////////////////////////////////////////////////////
	trn = trnSource.Hdr;
	if( trn )
	{
		/// SY 05/24/2005 v8.0240 QA70-6721 ASCIMP_OPTIONS_USE_GETNBOX
		///	aiTarget.iAutoSubHeaderLines = 0; // always turn off
		/// end ASCIMP_OPTIONS_USE_GETNBOX
	
		// Main header lines is copied by ID
		///trn.MainHeaderLines.nVal
	
		/// AW 10/17/06 NEW_IMPASC_OPTIONS
		/*
		if( trn.ShortNames.nVal <= 0 )
			aiTarget.iRenameCols = 0;
		else
		{
			/// SY 05/24/2005 v8.0240 QA70-6721 ASCIMP_OPTIONS_USE_GETNBOX
			///	aiTarget.iRenameCols = trn.MainHeaderLines.nVal + 1 - trn.ShortNames.nVal;
			if( trn.MainHeaderLines.nVal )
				aiTarget.iRenameCols = trn.MainHeaderLines.nVal + 1 - trn.ShortNames.nVal;
			else
				aiTarget.iRenameCols = trn.ShortNames.nVal;
			/// end ASCIMP_OPTIONS_USE_GETNBOX
		}
	
		// Long Names and Units are copied by ID, but need to be decremented
		// because internally -1 = none and 0 = first line.
		aiTarget.nLongNames--;
		aiTarget.nUnits--;
		
		// Comments
		if( trn.CommentsFrom.nVal <= 0 )
		{
			aiTarget.iLabels = 0; // 0 = none
			aiTarget.iMaxLabels = 0;
			aiTarget.iSubHeaderLines = 0;
		}
		else
		{
			/// SY 05/24/2005 v8.0240 QA70-6721 ASCIMP_OPTIONS_USE_GETNBOX
			///	aiTarget.iLabels = trn.MainHeaderLines.nVal + 1 - trn.CommentsFrom.nVal;
			if( trn.MainHeaderLines.nVal )
				aiTarget.iLabels = trn.MainHeaderLines.nVal + 1 - trn.CommentsFrom.nVal;
			else
				aiTarget.iLabels = trn.CommentsFrom.nVal;
			/// end ASCIMP_OPTIONS_USE_GETNBOX
			aiTarget.iMaxLabels = trn.CommentsTo.nVal - trn.CommentsFrom.nVal + 1;
			aiTarget.iSubHeaderLines = aiTarget.iHeaderLines + 1 - aiTarget.iLabels;
			aiTarget.iHeaderLines -= aiTarget.iSubHeaderLines;
		}
		// Parameters
		aiTarget.nFirstParams--; // -1=none,0=first line, etc
		if( aiTarget.nFirstParams < 0 )
			aiTarget.nNumParams = 0;
		else
			aiTarget.nNumParams -= aiTarget.nFirstParams;
	
		// Lines to Save
		aiTarget.nFirstSave--; // -1=none,0=first line, etc
		if( aiTarget.nFirstSave < 0 )
			aiTarget.nNumSave = 0;
		else
			aiTarget.nNumSave -= aiTarget.nFirstSave;
		*/
		if ( !aiTarget.iAutoSubHeaderLines )
		{
			if ( aiTarget.iSubHeaderLines < 0)
				aiTarget.iSubHeaderLines = 0;
			int nTotalHeaderLines = aiTarget.iHeaderLines + aiTarget.iSubHeaderLines;  
			int nOffset = aiTarget.iHeaderLines - 1;
			
			if ( trn.CommsFrom.nVal > 0 )
			{
				aiTarget.iMaxLabels = trn.CommsTo.nVal - trn.CommsFrom.nVal + 1;
			}
			else
			{
				aiTarget.iLabels = 0;
				aiTarget.iMaxLabels = 0;
			}
			
 			if ( aiTarget.iRenameCols > 0 )
				aiTarget.iRenameCols = nTotalHeaderLines - aiTarget.iRenameCols - nOffset;
			else
				aiTarget.iRenameCols = 0;

			if ( aiTarget.nLongNames > 0 )
				aiTarget.nLongNames += nOffset;
			else
				aiTarget.nLongNames = -1;
			if ( aiTarget.nUnits > 0 )
				aiTarget.nUnits += nOffset;
			else
				aiTarget.nUnits = -1;
			
			// Parameters
			if ( aiTarget.nFirstParams > 0 )
			{
				aiTarget.nNumParams -= aiTarget.nFirstParams - 1;
				aiTarget.nFirstParams += nOffset;	
			}
			else
			{
				aiTarget.nFirstParams = -1;
				aiTarget.nNumParams = 0;
			}
			
			///---Sim 01-26-2007 SUPPORT_USER_PARAMETER		
			// User Parameters
			if ( aiTarget.nFirstUserParams > 0 )
			{
				aiTarget.nNumUserParams -= aiTarget.nFirstUserParams - 1;
				aiTarget.nFirstUserParams += nOffset;	
			}
			else
			{
				aiTarget.nFirstUserParams = -1;
				aiTarget.nNumUserParams = 0;
			}
			///---END SUPPORT_USER_PARAMETER		
			// Lines to Save
			/*
			if ( aiTarget.nFirstSave > 0 )
			{
				aiTarget.nNumSave -= aiTarget.nFirstSave - 1;
				aiTarget.nFirstSave += nOffset;	
			}
			else
			{
				aiTarget.nFirstSave = -1;
				aiTarget.nNumSave = 0;
			}
			*/
		}
		else
		{
			///---Sim 05-29-2007 MAKE_HEADER_LINES_CONSISTENT_WITH_IMP_WIZ
			aiTarget.iHeaderLines = 0;
			///---END MAKE_HEADER_LINES_CONSISTENT_WITH_IMP_WIZ
			
			if ( trn.CommsFrom.nVal > 0 )
			{
				aiTarget.iMaxLabels = trn.CommsTo.nVal - trn.CommsFrom.nVal + 1;
			}
			else
			{
				aiTarget.iLabels = 0;
				aiTarget.iMaxLabels = 0;
			}
			
			if ( aiTarget.nFirstParams > 0 )
			{
				aiTarget.nNumParams -= aiTarget.nFirstParams - 1;
			}
			else
				aiTarget.nNumParams = 0;

			///---Sim 01-26-2007 SUPPORT_USER_PARAMETER		
			if ( aiTarget.nFirstUserParams > 0 )
			{
				aiTarget.nNumUserParams -= aiTarget.nFirstUserParams - 1;
			}
			else
				aiTarget.nNumUserParams = 0;
			///---END SUPPORT_USER_PARAMETER		
		}
		/// END NEW_IMPASC_OPTIONS
		
	}
	
	
	/// AW 10/06/06 MORE_ON_XF_THEME_BOOK_AND_SHEET
	// FileName node is used in trGUI, and we use hard codes to set, so there is a problem.
	//trn = trnSource.FileName;
	trn = trnSource.Names;
	/// END MORE_ON_XF_THEME_BOOK_AND_SHEET
	
	if( trn )
	{
		/// Hong 03/11/10 QA80-15192 SUPPORT_EDIT_BINARY_FILTER_CREATED_BY_IMPWIZ
		/*
		aiTarget.iRenameWks = (trn.FNameToSht.nVal ? 1 : 0);
		///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		//aiTarget.flags &= ~(AI_FLAG_FNAME_TO_WKBK_NAME|AI_FLAG_FNAME_TO_WKBK_COMMENTS|AI_FLAG_FNAME_TO_COL_COMMENTS|AI_FLAG_REMOVE_FNAME_PATH);
		aiTarget.flags &= ~(AI_FLAG_FNAME_TO_WKBK_NAME|AI_FLAG_FNAME_TO_WKBK_COMMENTS|AI_FLAG_FNAME_TO_COL_COMMENTS|AI_FLAG_REMOVE_FNAME_PATH
							|AI_FLAG_FNAME_TO_WKBK_LONG_NAME_ONLY);
		///---END QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		if( trn.FNameToBk.nVal )
			aiTarget.flags |= AI_FLAG_FNAME_TO_WKBK_NAME;
		///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		if( trn.FNameToBkLnOnly.nVal )
			aiTarget.flags |= AI_FLAG_FNAME_TO_WKBK_LONG_NAME_ONLY;
		///---END QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
		///---Sim 03-02-2007 ADD_FILE_PATH_OPTION_FOR_RENAME_WKBK
		if( trn.FPathToBk.nVal )
			aiTarget.flags &= ~AI_FLAG_REMOVE_FNAME_PATH_FOR_WKBK_NAME;
		else
			aiTarget.flags |= AI_FLAG_REMOVE_FNAME_PATH_FOR_WKBK_NAME;
		///---END ADD_FILE_PATH_OPTION_FOR_RENAME_WKBK
		if( trn.FNameToBkComm.nVal )
			aiTarget.flags |= AI_FLAG_FNAME_TO_WKBK_COMMENTS;
		if( trn.FNameToColComm.nVal )
			aiTarget.flags |= AI_FLAG_FNAME_TO_COL_COMMENTS;
		if( trn.FPathToComm.nVal )
			aiTarget.flags &= ~AI_FLAG_REMOVE_FNAME_PATH;
		else
			aiTarget.flags |= AI_FLAG_REMOVE_FNAME_PATH;
		*/
		bool 		bRenameWks;
		_get_rename_options(trn, bRenameWks, aiTarget.flags);
		aiTarget.iRenameWks= bRenameWks;
		/// end SUPPORT_EDIT_BINARY_FILTER_CREATED_BY_IMPWIZ
	}
	
	///////////////////////////////////////////////////////
	// Partial Import
	///////////////////////////////////////////////////////
	/// Hong 03/02/07 QA80-9015 ADD_PARTIAL_IMPORT_OPTION
	trn = trnSource.PartImp;
	if( trn )
	{
		aiTarget.iPartialC1--;
		aiTarget.iPartialC2--;
		aiTarget.iPartialR1--;
		aiTarget.iPartialR2--;
	}
	/// end ADD_PARTIAL_IMPORT_OPTION	
	///---Sim 04-12-2007 REORGANIZE_PARTIAL_RANGE_IMPORT
	if ( aiTarget.iPartial <= 0 )
	{
		aiTarget.iPartialC1 = 0;
		aiTarget.iPartialC2 = -1;
		aiTarget.iPartialR1 = 0;
		aiTarget.iPartialR2 = -1;
		
		aiTarget.iSkipRows = 0;
		aiTarget.iReadRows = 1;
	}
	///---END REORGANIZE_PARTIAL_RANGE_IMPORT
	
	/// AW 10/17/06 NEW_IMPASC_OPTIONS
	aiTarget.flags &= ~AI_FLAG_START_FROM_BOTTOM;
	/// Hong 07/10/08 v8.0899 FIX_RUNTIME_ERROR_FOR_NOT_FULL_GETN_TREE
	//if ( trnSource.Hdr.FromBottom.nVal )
	if ( trnSource.Hdr && trnSource.Hdr.FromBottom.nVal )
	/// end FIX_RUNTIME_ERROR_FOR_NOT_FULL_GETN_TREE
		aiTarget.flags |= AI_FLAG_START_FROM_BOTTOM;
	/// END NEW_IMPASC_OPTIONS

	
	trn = trnSource.Miscellaneous;
	if( trn )
	{
		/// Hong 11/13/06 FIX_IMPORT_MODE_CHANGED_INREASONABLE
		//////----------------- AW 11/01/06 FIX_AUTO_BUG_IN_ASC_IMP
		//aiTarget.iMode = _GetImportModeFromListIndex(trn.ImportMode.nVal); ///---Sim 02-12-2007 MAPPING_COMBO_LIST remove
		//trn.ImportMode.nVal = _GetImportModeFromListIndex(trn.ImportMode.nVal);
		//aiTarget.iMode = trn.ImportMode.nVal;
		//////----------------- END FIX_AUTO_BUG_IN_ASC_IMP
		/// end FIX_IMPORT_MODE_CHANGED_INREASONABLE
		
		/// Hong 03/23/07 v8.0589b IMPASC_ADD_TEXT_QUALIFIER_OPTION
		// "NONE|\"|\'"
		switch( trn.Qualifier.nVal )
		{  
		case 0: 
			aiTarget.cQuote = '\0';
			break;
		case 1: 
			string str("\""); // OC failed to compile '\"'
			aiTarget.cQuote = str[0];
			break;
		case 2:
			char szTemp[] = "'"; // OC failed to compile '\''
			aiTarget.cQuote = szTemp[0];
			break;
		}
		/// end IMPASC_ADD_TEXT_QUALIFIER_OPTION
		
		/// EJP 2005-06-27 v8.0258 QA70-7433 IMPORT_CSV_FILES
		if( trn.RemoveQuotes.nVal )
			aiTarget.flags |= AI_FLAG_REMOVE_QUOTES;
		else
			aiTarget.flags &= ~AI_FLAG_REMOVE_QUOTES;
		/// end IMPORT_CSV_FILES
		/// Hong 08/31/09 QA80-12899 IMP_WIZ_SUPPORT_KEEP_COL_FMTS_IN_TEMPLATE
		if ( trn.KeepDestColFmt )
		{
			if ( trn.KeepDestColFmt.nVal )
				aiTarget.flags |= AI_FLAG_KEEP_TARGET_SHEET_COL_FORMAT;
			else
				aiTarget.flags &= ~AI_FLAG_KEEP_TARGET_SHEET_COL_FORMAT;
		}
		/// end IMP_WIZ_SUPPORT_KEEP_COL_FMTS_IN_TEMPLATE
		/// Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
		if ( trn.SaveImpInfo )
		{
			if ( trn.SaveImpInfo.nVal )
				aiTarget.flags &= ~AI_FLAG_NO_IMPORT_INFO_TO_PAGE;
			else
				aiTarget.flags |= AI_FLAG_NO_IMPORT_INFO_TO_PAGE;
		}
		/// end /// Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
	}
	return TRUE;
}

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
// Begin Events
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
///---Sim 10-26-2006 FIX_GETN_IN_XF_EVENT_BUG
/*
static bool OnChangeMainHeaderLines(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return check_enable_header_lines(trn);
}

static bool OnChangeDataStruct(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return check_enable_file_struct(trn);
}

static bool OnChangeDelimiter(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return check_enable_file_struct(trn);
}

static bool OnChangeAutoColTypes(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return check_enable_testlines(trn);
}

static bool OnChangeAutoSubHeaderLines(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return check_enable_header_lines(trn);
}

static bool OnChangeCommentsFrom(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return check_enable_comments_to(trn);
}

static bool OnChangeParametersFrom(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return check_enable_parameters_to(trn);
}

static bool OnChangeSaveLinesFrom(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	TreeNode trnHdrLines = trn.HeaderLines;
	if( !trnHdrLines )
		return false;

	if( 0 == trnHdrLines.SaveLinesFrom.strVal.CompareNoCase(SZ_LISTITEM_NONE) )
		trnHdrLines.SaveLinesTo.strVal.Empty();
	else if( 0 == trnHdrLines.SaveLinesFrom.strVal.CompareNoCase(SZ_LISTITEM_ALL) )
		trnHdrLines.SaveLinesTo.strVal = SZ_LISTITEM_END;
	return check_enable_savelines_to(trn);
}
*/
static bool OnChangeMainHeaderLines(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{
	return check_enable_header_lines(trNode.Parent().Parent());
}
///---Sim 05-29-2007 MAKE_HEADER_LINES_CONSISTENT_WITH_IMP_WIZ
static bool OnChangeSubHeaderLines(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{
	return check_enable_header_lines(trNode.Parent().Parent());
}
///---END MAKE_HEADER_LINES_CONSISTENT_WITH_IMP_WIZ

static bool OnChangeDataStruct(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{
	return check_enable_file_struct(trNode.Parent().Parent());
}

static bool OnChangeDelimiter(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{
	return check_enable_file_struct(trNode.Parent().Parent());
}

///---Sim 11-14-2006 FIX_COLUMN_WIDTHS_BUG
static bool OnChangeColumnWidths(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{
	TreeNode trSetting = trNode.Parent().Parent();
	///---Sim 08-07-2007 FIX_IMP_ASC_OPTIONS
	if ( DATASTRUCT_FIXEDCOLWIDTHS == trSetting.FileStruct.DataStruct.nVal )
	{
	///---END FIX_IMP_ASC_OPTIONS
		if ( !trSetting.Cols.NumCols )
			return false;
		trSetting.Cols.NumCols.nVal = trNode.strVal.GetNumTokens(',');
	}///---Sim 08-07-2007 FIX_IMP_ASC_OPTIONS
	return true;
}
///---END FIX_COLUMN_WIDTHS_BUG
 
static bool OnChangeAutoColTypes(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{
	return check_enable_testlines(trNode.Parent().Parent());
}

static bool OnChangeAutoSubHeaderLines(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{
	return check_enable_header_lines(trNode.Parent().Parent());
}

static bool OnChangeCommentsFrom(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{
	return check_enable_comments_to(trNode.Parent().Parent());
}

static bool OnChangeParametersFrom(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{
	return check_enable_parameters_to(trNode.Parent().Parent());
}
///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
static bool OnChangeUserParametersFrom(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{
	return check_enable_user_parameters_to(trNode.Parent().Parent());
}
///---END SUPPORT_USER_PARAMETER

static bool OnChangeSaveLinesFrom(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{
	TreeNode trnHdrLines = trNode.Parent();
	if( !trnHdrLines )
		return false;

	if( 0 == trnHdrLines.SaveLnsFrom.strVal.CompareNoCase(SZ_LISTITEM_NONE) )
		trnHdrLines.SaveLnsTo.strVal.Empty();
	else if( 0 == trnHdrLines.SaveLnsFrom.strVal.CompareNoCase(SZ_LISTITEM_ALL) )
		trnHdrLines.SaveLnsTo.strVal = SZ_LISTITEM_END;
	return check_enable_savelines_to(trnHdrLines.Parent());
}
///---END FIX_GETN_IN_XF_EVENT_BUG

///---Sim 02-12-2007 ADD_AUTO_RENAME
static void _enable_file_name_options(TreeNode& trFileNameOptions)
{
	///---Sim 03-13-2007 CENTRALIZE_FILE_NAME_OPTIONS_ENABLE
	//int nEnable = (0 == trFileNameOptions.AutoRename.nVal) ? 1 : 0;
	//
	//trFileNameOptions.FileNameToWksName.Enable = nEnable;
	//int nWksTrimEnable = (nEnable && (1 == trFileNameOptions.FileNameToWksName.nVal)) ? 1 : 0;
	//trFileNameOptions.WksTrimFileNameFrom.Enable = nWksTrimEnable;
	//trFileNameOptions.WksTrimFileNameTo.Enable = nWksTrimEnable;
	//
	//trFileNameOptions.FileNameToWkbkName.Enable = nEnable;
	//int nWkbkTrimEnable = (nEnable && (1 == trFileNameOptions.FileNameToWkbkName.nVal)) ? 1 : 0;
	//trFileNameOptions.WkbkTrimFileNameFrom.Enable = nWkbkTrimEnable;
	//trFileNameOptions.WkbkTrimFileNameTo.Enable = nWkbkTrimEnable;
	
	bool bRenameWks, bRenameWksPartial, bRenameWkbk, bRenameWkbkPartial, bRenameWkbkIncludePath, bAppendIncludePath;
	///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
	//getEnableValueForFileNameOptions(trFileNameOptions.AutoNames.nVal,
		//trFileNameOptions.FNameToSht.nVal, trFileNameOptions.FNameToBk.nVal,
		//trFileNameOptions.FNameToBkComm.nVal, trFileNameOptions.FNameToColComm.nVal,
		//bRenameWks, bRenameWksPartial, bRenameWkbk, bRenameWkbkPartial, bRenameWkbkIncludePath, bAppendIncludePath);
	bool bRenameWkBkLnOnly;
	getEnableValueForFileNameOptions(trFileNameOptions.AutoNames.nVal,
		trFileNameOptions.FNameToSht.nVal, trFileNameOptions.FNameToBk.nVal,
		trFileNameOptions.FNameToBkComm.nVal, trFileNameOptions.FNameToColComm.nVal,
		bRenameWks, bRenameWksPartial, bRenameWkbk, bRenameWkbkPartial, bRenameWkBkLnOnly, bRenameWkbkIncludePath, bAppendIncludePath);
	///---END QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME

	trFileNameOptions.FNameToSht.Enable 			= bRenameWks;
	trFileNameOptions.FNameToShtFrom.Enable 	= bRenameWksPartial;
	trFileNameOptions.FNameToShtTo.Enable 	= bRenameWksPartial;
	
	trFileNameOptions.FNameToBk.Enable = bRenameWkbk;
	trFileNameOptions.FNameToBkFrom.Enable 	= bRenameWkbkPartial;
	trFileNameOptions.FNameToBkTo.Enable 	= bRenameWkbkPartial;
	trFileNameOptions.FNameToBkLnOnly.Enable	= bRenameWkBkLnOnly; ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
	trFileNameOptions.FPathToBk.Enable	= bRenameWkbkIncludePath;
	
	trFileNameOptions.FPathToComm.Enable	= bAppendIncludePath;	
	///---END CENTRALIZE_FILE_NAME_OPTIONS_ENABLE
}

static bool OnChangeRenameOptions(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{
	_enable_file_name_options(trNode.Parent());
	
	return true;
}

//static bool OnChangeAutoRename(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
//{
	//int nEnable = (0 == trNode.nVal) ? 1 : 0;
	//
	//TreeNode trFileNameOptions = trNode.Parent();
	//
	//trFileNameOptions.FNameToSht.Enable = nEnable;
	//trFileNameOptions.FileNameToWkbkName.Enable = nEnable;
	///// Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
	//int nTrimEnable = (nEnable && (1 == trFileNameOptions.FileNameToWksName.nVal)) ? 1 : 0;
	//trFileNameOptions.TrimFileNameFrom.Enable = nTrimEnable;
	//trFileNameOptions.TrimFileNameTo.Enable = nTrimEnable;
	///// end MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
	//
	//return true;
//}
//
///// Hong 02/27/07 QA80-9410 MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
//static bool OnChangeRenameWks(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
//{
	//TreeNode trFileNameOptions = trNode.Parent();
//
	//trFileNameOptions.TrimFileNameFrom.Enable = trNode.Enable && trNode.nVal;
	//trFileNameOptions.TrimFileNameTo.Enable = trNode.Enable && trNode.nVal;
	//
	//return true;
//}
///// end MORE_RENAME_WKS_TRIM_FNAME_FOR_XF
///---END ADD_AUTO_RENAME

///---Sim 04-12-2007 REORGANIZE_PARTIAL_RANGE_IMPORT 
static bool check_enable_partial_import(TreeNode& tn)
{
	if( !tn || !tn.Partial )
		return false;

	int nPartial = tn.Partial.nVal;
	if ( nPartial <= 0  )
	{	// disable all partial setting
		tree_set_attribute_to_all_nodes(tn, "Enable", "0");
		tn.Enable = 1;
		tn.Partial.Enable = 1;
	}
	else // nPartial > 0
	{	// enable all partial setting
		tree_set_attribute_to_all_nodes(tn, "Enable", "1");

		check_enable_skip_row(tn);
	}
	return true;
}
static bool check_enable_skip_row(TreeNode& tn)
{
	if ( !tn.SkipRows || !tn.ReadRows )
		return false;
	
	tn.ReadRows.Enable = (tn.SkipRows.Enable && (tn.SkipRows.nVal > 0) );
	
	return true;
	
}

/// Hong 03/02/07 QA80-9015 ADD_PARTIAL_IMPORT_OPTION
static bool OnChangePartialImport(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{
	return check_enable_partial_import(trNode.Parent());
}

static bool OnChangeSkipRow(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{
	return check_enable_skip_row(trNode.Parent());
}
/// end ADD_PARTIAL_IMPORT_OPTION
///---END REORGANIZE_PARTIAL_RANGE_IMPORT 

/// Hong 03/23/07 v8.0589b IMPASC_ADD_TEXT_QUALIFIER_OPTION
static bool OnChangetTextQualifier(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{
	TreeNode trMiscellaneous = trNode.Parent();
	
	bool bEnable = (0 == trNode.nVal) ? false:true;
	trMiscellaneous.RemoveQuotes.Enable = bEnable;
	
	return true;
}
/// end IMPASC_ADD_TEXT_QUALIFIER_OPTION

///---Sim 08-07-2008 v8.0918 QA80-11969 MULTI_ASC_IMP_SUPPORT_TEMPLATE
static bool OnChangeImportMode(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{
	int nImportMode = trNode.nVal;
	
	bool bTemplEnable = (ASCIMP_MODE_NEW_SHEETS == nImportMode || ASCIMP_MODE_NEW_BOOKS == nImportMode);
	
	TreeNode trOptions = trNode.Parent();
	
	TreeNode trTemplate = tree_get_node_by_id(trOptions, IDE_DISP_IMP_PAGETEMPLATE, true);
	
	trTemplate.Enable = bTemplEnable;
	
	return true;
}
///---END v8.0918 QA80-11969 MULTI_ASC_IMP_SUPPORT_TEMPLATE

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
// End Events
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

static bool check_enable_file_struct(TreeNode& trn)
{
	TreeNode trnFileStruct = trn.FileStruct;
	if( !trnFileStruct )
		return false;
	
	if( DATASTRUCT_DELIMITED == trnFileStruct.DataStruct.nVal )
	{
		trnFileStruct.Delimiter.Enable = true;
		if( ASCIMP_DELIM_OTHER == trnFileStruct.Delimiter.nVal )
			trnFileStruct.OtherDelimiter.Enable = true;
		else
			trnFileStruct.OtherDelimiter.Enable = false;
		///---Sim 08-07-2007 FIX_IMP_ASC_OPTIONS
		if( ASCIMP_DELIM_UNKNOWN == trnFileStruct.Delimiter.nVal )
			trnFileStruct.Delimiters.Enable = true;
		else
			trnFileStruct.Delimiters.Enable = false;
		///---END FIX_IMP_ASC_OPTIONS
		trnFileStruct.ColWidths.Enable = false;
	}
	else // fixed column widths
	{
		trnFileStruct.Delimiter.Enable = false;
		trnFileStruct.OtherDelimiter.Enable = false;
		trnFileStruct.ColWidths.Enable = true;
		/// Hong 02/09/10 QA80-14709-P7 FIX_IMPASC_OPTION_SHOW_HIDE
	#ifdef		__FIX_DELIMITERS_FAIL_WORK_WHEN_SIGNLE_CHAR__
		trnFileStruct.Delimiters.Enable = false;
	#endif		__FIX_DELIMITERS_FAIL_WORK_WHEN_SIGNLE_CHAR__
		/// end FIX_IMPASC_OPTION_SHOW_HIDE
	}
	return true;
}

static bool check_enable_testlines(TreeNode& trn)
{
	TreeNode trnCols = trn.Cols;
	if( !trnCols )
		return false;
	
	if( trnCols.AutoColTypes.nVal )
		trnCols.MinTestLns.Enable = true;
	else
		trnCols.MinTestLns.Enable = false;
	return true;
}

static bool check_enable_comments_to(TreeNode& trn)
{
	TreeNode trnHdrLines = trn.Hdr;
	if( !trnHdrLines )
		return false;

	int nLine = atoi(trnHdrLines.CommsFrom.strVal);
	trnHdrLines.CommsTo.Enable = (trnHdrLines.CommsFrom.Enable && nLine > 0);
	return true;
}

static bool check_enable_parameters_to(TreeNode& trn)
{
	TreeNode trnHdrLines = trn.Hdr;
	if( !trnHdrLines )
		return false;

	int nLine = atoi(trnHdrLines.ParamsFrom.strVal);
	trnHdrLines.ParamsTo.Enable = (trnHdrLines.ParamsFrom.Enable && nLine > 0);
	return true;
}

///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
static bool check_enable_user_parameters_to(TreeNode& trn)
{
	TreeNode trnHdrLines = trn.Hdr;
	if( !trnHdrLines )
		return false;

	int nLine = atoi(trnHdrLines.UParamsFrom.strVal);
	trnHdrLines.UParamsTo.Enable = (trnHdrLines.UParamsFrom.Enable && nLine > 0);
	return true;
}
///---END SUPPORT_USER_PARAMETER

static bool check_enable_savelines_from(TreeNode& trn)
{
	TreeNode trnHdrLines = trn.Hdr;
	if( !trnHdrLines )
		return false;

	int nLine = atoi(trnHdrLines.MainHdrLns.strVal);
	//trnHdrLines.SaveLnsFrom.Enable = nLine > 0;    /// AW 10/17/06 NEW_IMPASC_OPTIONS
	check_enable_savelines_to(trn);
	return true;
}

static bool check_enable_savelines_to(TreeNode& trn)
{
	TreeNode trnHdrLines = trn.Hdr;
	if( !trnHdrLines )
		return false;

	int nLine = atoi(trnHdrLines.SaveLnsFrom.strVal);
	trnHdrLines.SaveLnsTo.Enable = (trnHdrLines.SaveLnsFrom.Enable && nLine > 0);
	return true;
}

static bool check_enable_header_lines(TreeNode& trn)
{
	TreeNode trnHdrLines = trn.Hdr;
	if( !trnHdrLines )
		return false;

 	///---Sim 05-29-2007 MAKE_HEADER_LINES_CONSISTENT_WITH_IMP_WIZ
	//BOOL bEnable = (trnHdrLines.MainHeaderLines.nVal > 0);
 	///---END MAKE_HEADER_LINES_CONSISTENT_WITH_IMP_WIZ
	
	/// AW 10/17/06 NEW_IMPASC_OPTIONS 
	/// when header line number is unknow, need enable autodetemine subheader
	/*
	if ( !bEnable )
	{
		trnHdrLines.AutoSubHeaderLines.nVal = 1;
		trnHdrLines.AutoSubHeaderLines.Enable = 1;
	}
	bEnable = 0 == trnHdrLines.AutoSubHeaderLines.nVal ;
	*/
	/// END NEW_IMPASC_OPTIONS
	
 	///---Sim 05-29-2007 MAKE_HEADER_LINES_CONSISTENT_WITH_IMP_WIZ
	trnHdrLines.MainHdrLns.Enable = trnHdrLines.AutoSubHdr.nVal == 0;
 	///---END MAKE_HEADER_LINES_CONSISTENT_WITH_IMP_WIZ
	/// SY 05/24/2005 v8.0240 QA70-6721 ASCIMP_OPTIONS_USE_GETNBOX
	trnHdrLines.SubHdrLns.Enable = trnHdrLines.AutoSubHdr.nVal == 0;
	/// end ASCIMP_OPTIONS_USE_GETNBOX
	
 	///---Sim 05-29-2007 MAKE_HEADER_LINES_CONSISTENT_WITH_IMP_WIZ
 	BOOL bEnableHeader = (trnHdrLines.AutoSubHdr.nVal > 0 || trnHdrLines.SubHdrLns.nVal > 0);
 	
	trnHdrLines.SNames.Enable = bEnableHeader;
	trnHdrLines.LNames.Enable = bEnableHeader;
	trnHdrLines.Units.Enable = bEnableHeader;
	trnHdrLines.CommsFrom.Enable = bEnableHeader;
	trnHdrLines.ParamsFrom.Enable = bEnableHeader;
 	trnHdrLines.UParamsFrom.Enable = bEnableHeader;
	///---END MAKE_HEADER_LINES_CONSISTENT_WITH_IMP_WIZ
 	
	/// AW 10/17/06 NEW_IMPASC_OPTIONS
	/*
	trnHdrLines.ShortNames.Enable = bEnable;
	trnHdrLines.LongNames.Enable = bEnable;
	trnHdrLines.Units.Enable = bEnable;
	trnHdrLines.CommentsFrom.Enable = bEnable;
	check_enable_comments_to(trn);
	trnHdrLines.ParamsFrom.Enable = bEnable;
	*/
	if ( trnHdrLines.AutoSubHdr.nVal == 0 )
	{
		trnHdrLines.FromBottom.Enable = false;
		trnHdrLines.FromBottom.nVal = 0;
	}
	else
	{
		trnHdrLines.FromBottom.Enable = true;
	}
	
	check_enable_comments_to(trn);
	/// END NEW_IMPASC_OPTIONS
	check_enable_parameters_to(trn);
	check_enable_user_parameters_to(trn); ///---Sim 01-26-2007 SUPPORT_USER_PARAMETER	
	
	/// AW 10/17/06 NEW_IMPASC_OPTIONS
	// all header info will be saved no need set these
	//check_enable_savelines_from(trn);
	trnHdrLines.SaveLnsFrom.Show = false;  	
	trnHdrLines.SaveLnsTo.Show = false; 
	/// END NEW_IMPASC_OPTIONS
	
	return true;
}

/// SY 11-17-2004 v8.0164 QA70-6721 ASCIMP_OPTIONS_USE_GETNBOX
///---Sim 10-26-2006 FIX_GETN_IN_XF_EVENT_BUG
/*
static bool OnClickUpdateOptions(TreeNode& trn, int nRow, int nType, Dialog& dlg)
{
	return update_options(trn);
}
*/
static bool OnClickUpdateOptions(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{
	return update_options(trNode.Parent());
}
///---END FIX_GETN_IN_XF_EVENT_BUG

static bool update_options(TreeNode& trn)
{
	Page pg = Project.Pages();
	if( !pg )
		return false; // error

	Layer ly = pg.Layers();
	if( !ly )
		return false; // error
	
	Worksheet wks(ly);
	if( !wks )
		return false;
	
	ASCIMP ai;
	GetNTreeToASCIMP(ai, trn);
	wks.SetASCIMP(ai);
	
	return true;
}
/// end ASCIMP_OPTIONS_USE_GETNBOX

/// SY 05/20/2005 QA70-7650 v8.0239 MORE_IMPORT_MODE_IN_OLD_ASCII_IMPORT_DLG
static Page GetTargetDataPage(ASCIMP& ai, Page &pgTarget, int nPgTargetType, int nFile = 0)
{
	int nPageType = EXIST_NONE;
	if( pgTarget )
		nPageType = pgTarget.GetType();

	int nImportMode = ai.iMode;
	if( ASCIMP_MODE_AUTO == nImportMode )
	{
		if( ai.flags & AI_FLAG_FNAME_TO_WKBK_NAME )
			nImportMode = ASCIMP_MODE_NEW_BOOKS;
		else if( ai.iRenameWks )
			nImportMode = ASCIMP_MODE_NEW_SHEETS;
		else
			nImportMode = ASCIMP_MODE_REPLACE_DATA;
	}

	if( nPgTargetType == nPageType )
	{
		switch( nImportMode )
		{
		case ASCIMP_MODE_REPLACE_DATA:
			if( 0 == nFile )
				return pgTarget;
			break;
		case ASCIMP_MODE_APPEND_COLS:
		case ASCIMP_MODE_APPEND_ROWS:
			return pgTarget;
		case ASCIMP_MODE_NEW_BOOKS:
			break;
		case ASCIMP_MODE_NEW_SHEETS:
			int nLayer = pgTarget.AddLayer();
			if( nLayer >= 0 )
				page_set_active_layer(pgTarget, nLayer);
			return pgTarget;
		default:
			ASSERT(FALSE); // should never come here
		}
	}

	Page pg;
	return pg; // return junk, need caller to create the target page
}
/// end MORE_IMPORT_MODE_IN_OLD_ASCII_IMPORT_DLG


#define TEST_DATA_FILE "D:\\share\\data\\ascii\\header\\p3_ln_u.txt"
void ocimport()
{
	setup_active_ascimp();
	
	Page pg = Project.Pages();
	if( !pg )
		return;

	Layer ly = pg.Layers();
	if( !ly )
		return;
	
	Worksheet wks(ly);
	if( !wks )
		return;
	
	ASCIMP ai;
	wks.GetASCIMP(ai);

	int n = wks.ImportASCII(TEST_DATA_FILE, ai);
	printf("ImportASCII returned %d\n", n);
}

void ltimport()
{
	setup_active_ascimp();

	Page pg = Project.Pages();
	if( !pg )
		return;
	
	string str;
	str.Format("open -w %s", TEST_DATA_FILE);
	pg.LT_execute(str);
}

void setup_active_ascimp()
{
	Page pg = Project.Pages();
	if( !pg )
		return;

	Layer ly = pg.Layers();
	if( !ly )
		return;
	
	Worksheet wks(ly);
	if( !wks )
		return;
	
	ASCIMP ai;
	wks.GetASCIMP(ai);

	ai.iHeaderLines = 5; // 0
	ai.iSubHeaderLines = 0; // 0
	ai.iAutoSubHeaderLines = 0; // 1
	//ai.iTestLines = 4; // 3

	ai.iRenameCols = 0; // 1

	ai.iLabels = 0; // 1
	ai.iMaxLabels = 0; // 7
	
	//ai.nLongNames = 3; // -1
	//ai.nUnits = 4; // -1
	ai.nFirstParams = 0;
	ai.nNumParams = 3;
	
	wks.SetASCIMP(ai);
}

void dumpactiveai()
{
	Page pg = Project.Pages();
	if( !pg )
		return;

	Layer ly = pg.Layers();
	if( !ly )
		return;
	
	Worksheet wks(ly);
	if( !wks )
		return;

	ASCIMP ai;
	wks.GetASCIMP(ai);
	dumpai(ai);
}
void dumpai(ASCIMP& ai)
{
	Tree tr;
	tr = ai;
	out_tree(tr);
}

///---Sim 09-27-2006 SUPPORT_CONVERT_FILTER_TO_OPTIONS
/// Hong 03/02/07 QA-9418 ADD_REPEAT_IMPORT
//bool FilterToOptions(const TreeNode& trFilter, TreeNode& trOptions)
bool FilterToOptions(const TreeNode& trFilter, TreeNode& trOptions, BOOL bReimport)
/// end ADD_REPEAT_IMPORT
{
	///---Sim 06-04-2007 FIX_RUN_TIME_ERROR
	if ( !trFilter  || !trOptions )
		return false;
	///---END FIX_RUN_TIME_ERROR
	
	///---Sim 05-25-2007 MOVE_SPARKLINE_TO_OPTIONS_TREE
	//trOptions.sparkline.nVal = fuGetSparkLine(trFilter);
	tree_copy_values_by_id(trFilter, trOptions);
	///---END MOVE_SPARKLINE_TO_OPTIONS_TREE
	
	///---Sim 03-16-2007 QA80-9418-P1 FIX_LONG_NAME_NOT_UPDATE_WHEN_REIMPORT
	ASCIMP ai;
	///---Sim 05-25-2007 USE_MORE_GENERAL_UTILS_FUNC
	//ai = trFilter.GetNode(IMPORT_FILTER_ASCIMP);
	fuGetASCIMP(trFilter, ai);
	///---END USE_MORE_GENERAL_UTILS_FUNC
	if ( !ASCIMPToGetNTree(trOptions, ai) )
		return false;
	
	//if( tree_copy_values_by_id(trFilter, trOptions) <= 0 )
		//return false;
	
	//int nValue;
	//string strValue;
	
	TreeNode trn;
	
	///////////////////////////////////////////////////////
	// File Sturct
	///////////////////////////////////////////////////////
	trn = trOptions.FileStruct;
	if( !trn )
		return false;
	/// Hong 03/02/07 QA-9418 ADD_REPEAT_IMPORT
	if(bReimport)
		trn.Enable = 2;
	/// end ADD_REPEAT_IMPORT
	//trn.DataStruct.nVal = (fuGetInt(trFilter, IDE_ASCIMP_DELIMITED, 0) ? DATASTRUCT_DELIMITED : DATASTRUCT_FIXEDCOLWIDTHS);
	//trn.Delimiter.nVal = fuGetInt(trFilter, IDE_ASCIMP_DELIMCODE, 0);
	//trn.OtherDelimiter.strVal = fuGetStr(trFilter, IDE_ASCIMP_DELIMCHAR, "");
	//trOptions.FileStruct.ColumnWidths.strVal = fuGetStr(trFilter, IDE_ASCIMP_COLWIDTHS, "");
	
	//nValue = fuGetInt(trFilter, IDE_ASCIMP_NUMSEP, 0);
	//if( NF_IS_ORIGIN == nValue )
		//nValue = 0;
	//trn.NumericSeparator.nVal = nValue;
	//
	//check_enable_file_struct(trOptions);

	///////////////////////////////////////////////////////
	// Columns
	///////////////////////////////////////////////////////
	/*
	trn = trOptions.Columns;
	if( !trn )
		return false;
	
	nValue = fuGetInt(trFilter, IDE_ASCIMP_NUMCOLUMNS, 0);
	if( nValue > 0 )
		strValue.Format("%d", nValue);
	else
		strValue = SZ_LISTITEM_UNKNOWN;
	trn.NumColumns.strVal = strValue;
	
	trn.AutoColTypes.nVal = (fuGetInt(trFilter, IDE_ASCIMP_AUTOCOLTYPES, 0) ? 1 : 0); 
	trn.NumTestLines.nVal = fuGetInt(trFilter, IDE_ASCIMP_TESTLINES, 0);
	trn.MaxScanLines.nVal = fuGetInt(trFilter, IDE_ASCIMP_MAXTESTLINES, 0);
	*/	
	//check_enable_testlines(trOptions);

	///////////////////////////////////////////////////////
	// Header Lines
	///////////////////////////////////////////////////////
	//trn = trOptions.HeaderLines;
	//if( !trn )
		//return false;
//
	//// Main header lines is copied by ID
	/////trn.MainHeaderLines.nVal
	//trn.MainHeaderLines.nVal += fuGetInt(trFilter, IDE_ASCIMP_SUBHEADLINES, 0);
//
	//nValue = fuGetInt(trFilter, IDE_ASCIMP_RENAMECOLS, 0);
	//if( nValue <= 0 )
		//trn.ShortNames.nVal = 0; // 0 = none
	//else
	//{
		//if( trn.MainHeaderLines.nVal )
			//trn.ShortNames.nVal = trn.MainHeaderLines.nVal + 1 - nValue;
		//else
			//trn.ShortNames.nVal = nValue;
	//}
//
	//// Long Names and Units are copied by ID, but need to be incremented
	//// because internally -1 = none and 0 = first line.
	//trn.LongNames.nVal++;
	//trn.Units.nVal++;
//
	//// Comments
	//if( fuGetInt(trFilter, IDE_ASCIMP_LABEL, 0) <= 0 )
	//{
		////trn.CommentsFrom.nVal = 0; // 0 = none
		////trn.CommentsTo.nVal = 0;
	//}
	//else
	//{
		//// Comments From is copied by ID, but now need to offset by header lines
		//// because Comments must be in sub-header lines.
		//trn.CommentsFrom.nVal += fuGetInt(trFilter, IDE_ASCIMP_HEADLINES, 0);
		//trn.CommentsTo.nVal = trn.CommentsFrom.nVal + fuGetInt(trFilter, IDE_ASCIMP_MAXLABELS, 0) - 1;
	//}
	//
	//
	//// Parameters
	//trn.ParamsFrom.nVal++;
	//trn.ParamsTo.nVal += trn.ParamsFrom.nVal - 1;
	//
	/////---Sim 01-26-2007 SUPPORT_USER_PARAMETER
	//// User Parameters
	//trn.UserParamsFrom.nVal++;
	//trn.UserParamsTo.nVal += trn.UserParamsFrom.nVal - 1;
	/////---END SUPPORT_USER_PARAMETER
	//
	//// Save Lines
	//trn.SaveLinesFrom.nVal++;
	//trn.SaveLnsTo.nVal += trn.SaveLinesFrom.nVal;
//
	//check_enable_header_lines(trOptions);

	///////////////////////////////////////////////////////
	// File Name
	///////////////////////////////////////////////////////
	
	/// AW 10/06/06 MORE_ON_XF_THEME_BOOK_AND_SHEET
	// FileName node is used in trGUI, and we use hard codes to set, so there is a problem.
	//trn = trOptions.FileName;
	//trn = trOptions.FileNameSetting;
	/// END MORE_ON_XF_THEME_BOOK_AND_SHEET

	//if( !trn )
		//return false;

	//trn.FileNameToWksName.nVal = fuGetInt(trFilter, IDE_ASCIMP_RENAMEWKS, 0);
	
	//DWORD flags = (DWORD)fuGetInt(trFilter, IDE_ASCIMP_FLAGS, 0);
	//trn.FileNameToWkbkName.nVal = flags & AI_FLAG_FNAME_TO_WKBK_NAME;
	//trn.RenameWkbkIncludePath.nVal = (flags & AI_FLAG_REMOVE_FNAME_PATH_FOR_WKBK_NAME ? 0 : 1); ///---Sim 03-02-2007 ADD_FILE_PATH_OPTION_FOR_RENAME_WKBK
	//trn.AppendFileNameToWkbkComments.nVal = flags & AI_FLAG_FNAME_TO_WKBK_COMMENTS;
	//trn.AppendFileNameToColComments.nVal = flags & AI_FLAG_FNAME_TO_COL_COMMENTS;
	//trn.IncludePathWhenAppend.nVal = (flags & AI_FLAG_REMOVE_FNAME_PATH ? 0 : 1);
//
	///////////////////////////////////////////////////////
	// Partial Import
	///////////////////////////////////////////////////////
	/// Hong 03/02/07 QA80-9015 ADD_PARTIAL_IMPORT_OPTION
	//trn = trOptions.PartialImport;
	//if( trn )
	//{
		//trn.ColumnFrom.nVal++;
		//trn.ColumnTo.nVal++;
		//trn.RowFrom.nVal++;
		//trn.RowTo.nVal++;
	//}
	/// end ADD_PARTIAL_IMPORT_OPTION	
	
	///////////////////////////////////////////////////////
	// Miscellaneous
	///////////////////////////////////////////////////////
	/// EJP 2005-05-04 v8.0229 QA70-6555 NEW_IMPORT_MODES
	trn = trOptions.Miscellaneous;
	if( !trn )
		return false;
	
	//trn.ImportMode.nVal = _GetListIndexFromImportMode(fuGetInt(trFilter, IDE_ASCIMP_IMPORTMODE, 0)); ///---Sim 02-12-2007 MAPPING_COMBO_LIST remove
	/// end NEW_IMPORT_MODES

	/// EJP 2005-06-27 v8.0258 QA70-7433 IMPORT_CSV_FILES
	//flags = (DWORD)fuGetInt(trFilter, IDE_ASCIMP_FLAGS, 0);
	//trn.RemoveQuotes.nVal = (flags & AI_FLAG_REMOVE_QUOTES ? 1 : 0);
	/// end IMPORT_CSV_FILES
	/// Hong 03/02/07 QA-9418 ADD_REPEAT_IMPORT
	if(bReimport)
	{
		/// Hong 03/27/07 v8.0590 MORE_RESTRICTION_FOR_REIMPORT
		//trn.ImportMode.Enable = 2;
		trn.Enable = 2;
		//_L("Terminate Import|Read as Text|Start New Worksheet|Start New Column")
		if( 1 < trn.NonNum.nVal ) // use "Terminate Import" for "Start New Worksheet" and "Start New Column" when reimport
			trn.NonNum.nVal = 0;
		/// end MORE_RESTRICTION_FOR_REIMPORT
		///---Sim 05-05-2007 ADD_1ST_IMPORT_MODE
		//trn.1stImportMode.nVal = ASCIMP_MODE_REPLACE_DATA;
		///---END ADD_1ST_IMPORT_MODE
		/// Hong 06/20/07 v8.0645 MOVE_IMPMODE_TO_HIGHER_LEVEL_ASDED_BY_JUSTIN
		//trn.ImpMode.nVal = ASCIMP_MODE_REPLACE_DATA;
		TreeNode trImpMode = tree_get_node_by_id(trOptions, IDE_ASCIMP_IMPORTMODE, true);

		if ( trImpMode )
		{
			trImpMode.Enable = ENABLE_READ_ONLY; /// Hong 06/16/08 QA80-10541 DISABLE_IMPORT_MODE_WHEN_REIMPORT
			trImpMode.nVal = ASCIMP_MODE_REPLACE_DATA;
		}
		/// end MOVE_IMPMODE_TO_HIGHER_LEVEL_ASDED_BY_JUSTIN
	}
	/// end ADD_REPEAT_IMPORT
	
	///---END QA80-9418-P1 FIX_LONG_NAME_NOT_UPDATE_WHEN_REIMPORT
	return true;	
}
///---END SUPPORT_CONVERT_FILTER_TO_OPTIONS

///---Sim 05-24-2007 SUPPORT_CONVERT_OPTIONS_TO_FILTER
bool OptionsToFilter(const TreeNode& trOptions, TreeNode& trFilter)
{
	///---Sim 06-04-2007 FIX_RUN_TIME_ERROR
	if ( !trOptions || !trFilter )
		return false;
	///---END FIX_RUN_TIME_ERROR
	
	if ( FILTER_TYPE_ASCII != fuGetType(trFilter) )
		return false;
	
	tree_copy_values_by_id(trOptions, trFilter);
	ASCIMP ascimp;	
	initASCIMP(ascimp); /// Hong 07/10/08 v8.899 FIX_DEFAULT_VALUE_LOST_WHEN_PARTIAL_GETN_TREE	
	if ( !GetNTreeToASCIMP(ascimp, trOptions) )
		return false;
	fuSetASCIMP(trFilter, ascimp);
	
	///---Sim 05-29-2007 ONLY_ONE_IMPORT_MODE_SAME_AS_IMP_WIZ
	fuSet1stImportMode(trFilter, fuGetImportMode(trFilter));
	///---END ONLY_ONE_IMPORT_MODE_SAME_AS_IMP_WIZ
	///---Sim 05-25-2007 MOVE_SPARKLINE_TO_OPTIONS_TREE
	//fuSetSparkLine(trFilter, trOptions.sparkline.nVal);
	///---END MOVE_SPARKLINE_TO_OPTIONS_TREE
	
	return true;	
}
///---END SUPPORT_CONVERT_OPTIONS_TO_FILTER

/// Hong 03/11/10 QA80-15192 SUPPORT_EDIT_BINARY_FILTER_CREATED_BY_IMPWIZ
void construct_binary_import_options(TreeNode& trGetN)
{
	GETN_USE(trGetN);
	GETN_OPTION_BRANCH(GETNBRANCH_OPEN)		///Joseph 04/25/07 FIX_BUG_SOULD_KEEP_THE_OPEN_STATUS
	
	GETN_LIST(sparklines, _L("Add Sparklines"), 2, STR_COMBO_SPARKLINE)
		GETN_ID(IDE_DISP_IMP_SPARKLINES)
	
	string str1stCombo, str1stMapping;
	str1stCombo = getImportModeListString(str1stMapping, IW_FLAG_IMPMODE_REPLACE | IW_FLAG_IMPMODE_NEW_BOOKS \
		 | IW_FLAG_IMPMODE_NEW_SHEETS | IW_FLAG_IMPMODE_NEW_COLS | IW_FLAG_IMPMODE_NEW_ROWS);
	
	GETN_LIST(ImpMode, _L("Import Mode"), ASCIMP_MODE_NEW_SHEETS, str1stCombo) GETN_ID(IDE_ASCIMP_IMPORTMODE)
		GETN_ADD_INT_MAP(str1stMapping)
		GETN_OPTION_EVENT_EX(OnChangeImportMode)
	
	GETN_BUTTON(Template, _L("Template Name"), "")
		GETN_ID(IDE_DISP_IMP_PAGETEMPLATE)
		GETN_STR_COMBO("...File: ImportFileTemplates");
	
	_construct_rename_options(GETN_CURRENT_NODE);
	_construct_partial_options(GETN_CURRENT_NODE);
	
	GETN_BEGIN_BRANCH(Miscellaneous, _L("Miscellaneous"))
		GETN_CHECK(KeepDestColFmt, _L("Keep Target Column Format"), 0) GETN_ID(IDE_ASCIMP_KEEP_DEST_COL_FMT)
		GETN_CHECK(BigEndian, _L("Big-Endian byte order"), 0) GETN_ID(IDE_BINIMP_BIGENDIAN)
	GETN_END_BRANCH(Miscellaneous)
}

bool BINIMPToGetNTree(const BINIMP& binimp, TreeNode& trOptions)
{
	Tree 		trBI;
	trBI = binimp;
	if( tree_copy_values_by_id(trBI, trOptions) <= 0 )
		return false;
	
	// Values not be copied by DataID
	TreeNode trn;

	trn = trOptions.Names;	
	if( trn )
	{
		_set_rename_options(trn, binimp.iRenameWks, binimp.flags);
	}
	
	///////////////////////////////////////////////////////
	// Partial Import
	///////////////////////////////////////////////////////
	trn = trOptions.PartImp;
	if( trn )
	{
		trn.FirstCol.nVal++;
		trn.LastCol.nVal++;
		trn.FirstRow.nVal++;
		trn.LastRow.nVal++;
	}
	
	trn = trOptions.Miscellaneous;
	if( trn )
	{
		if ( trn.KeepDestColFmt )
			trn.KeepDestColFmt.nVal = (AI_FLAG_KEEP_TARGET_SHEET_COL_FORMAT & binimp.flags) ? 1 : 0;
	}
	
	return true;
}

bool GetNTreeToBINIMP(const TreeNode& trSrc, BINIMP& binimp)
{
	Tree 		trBI;
	trBI = binimp;
	if( tree_copy_values_by_id(trSrc, trBI) <= 0 )
		return false;
	binimp = trBI;

	// Values not copied by DataID
	TreeNode trn;
	
	trn = trSrc.Names;
	if( trn )
	{
		bool 		bRenameWks;
		_get_rename_options(trn, bRenameWks, binimp.flags);
		binimp.iRenameWks= bRenameWks;
	}
	
	///////////////////////////////////////////////////////
	// Partial Import
	///////////////////////////////////////////////////////
	trn = trSrc.PartImp;
	if( trn )
	{
		binimp.iPartialC1--;
		binimp.iPartialC2--;
		binimp.iPartialR1--;
		binimp.iPartialR2--;
	}
	if ( binimp.iPartial <= 0 )
	{
		binimp.iPartialC1 = 0;
		binimp.iPartialC2 = -1;
		binimp.iPartialR1 = 0;
		binimp.iPartialR2 = -1;
		
		binimp.iSkipRows = 0;
		binimp.iReadRows = 1;
	}

	trn = trSrc.Miscellaneous;
	if( trn )
	{
		if ( trn.KeepDestColFmt )
		{
			O_SET_BIT(binimp.flags, AI_FLAG_KEEP_TARGET_SHEET_COL_FORMAT, trn.KeepDestColFmt.nVal);
		}
	}
	return TRUE;
}

bool BinaryFilterToOptions(const TreeNode& trFilter, TreeNode& trOptions)
{
	if ( !trOptions || !trFilter )
		return false;
	
	if ( FILTER_TYPE_BINARY != fuGetType(trFilter) )
		return false;
	
	tree_copy_values_by_id(trFilter, trOptions);
	
	BINIMP 		binimp;
	fuGetBINIMP(trFilter, binimp);
	if ( !BINIMPToGetNTree(binimp, trOptions) )
		return false;
	
	return true;
}

bool BinaryOptionsToFilter(const TreeNode& trOptions, TreeNode& trFilter, bool bReintBINIMP)
{
	if ( !trOptions || !trFilter )
		return false;
	
	if ( FILTER_TYPE_BINARY != fuGetType(trFilter) )
		return false;
	
	tree_copy_values_by_id(trOptions, trFilter);
	
	BINIMP 		binimp;
	if ( bReintBINIMP )
		initBINIMP(binimp);
	else
		fuGetBINIMP(trFilter, binimp);
	if ( !GetNTreeToBINIMP(trOptions, binimp) )
		return false;
	fuSetBINIMP(trFilter, binimp);
	
	fuSet1stImportMode(trFilter, fuGetImportMode(trFilter));
	
	return true;
}
/// end SUPPORT_EDIT_BINARY_FILTER_CREATED_BY_IMPWIZ

//////////////////////////////////////////////////////
//////////////////////////////////////////////////////
//////////////////////////////////////////////////////
// Begin OC functions to be used from LabTalk
//////////////////////////////////////////////////////
//////////////////////////////////////////////////////
//////////////////////////////////////////////////////
#pragma labtalk(2)	// the following can be used from LT only inside the "run -oc cmd" syntax, or "run -oc {val=func(arg)}" syntax.

/// Hong 12/19/08 QA80-12736 FIX_IMPORT_ASCII_FAIL_IMPORT_TO_GRAPH
/// SY 05/20/2005 QA70-7650 v8.0239 MORE_IMPORT_MODE_IN_OLD_ASCII_IMPORT_DLG
void set_ascii_import_page_info(string lpcszFile);

// if strBookSheet not specified, import into current, if current is a graph, create a new book using
// strTemplate and made hidden and sel all cols and plot
BOOL AscImport(string strFilename, string strBookSheet = "", string strTemplate = "", string strDesignation = "", BOOL bMulti = false)
{
	if( !strFilename.IsFile() )
		return false;
	
	Page pg(strBookSheet);
	if( !pg )
		return false; // error

	int	nPageType = pg.GetType();
	ASCIMP ai;
	using FDLog = LabTalk.FDLog;                 // Use LabTalk FDLog object

	int nRet = 0;
	switch( nPageType )
	{
	case EXIST_WKS:
	case EXIST_EXTERN_WKS: /// EJP 2005-07-28 v8.0277 FIX_SUPPORT_FOR_IMPORT_ASCII_INTO_EXCEL_SHEET
		{
			Layer ly = pg.Layers();
			if( !ly )
				return false;
		
			Worksheet wks(ly);
			if( !wks )
				return false;
			wks.GetASCIMP(ai);
			
			if( bMulti )
				ai.iMode = _GetImportModeFromListIndex(FDLog.MultiOpen.ComboSel);
			
			Page pgTarget = GetTargetDataPage(ai, pg, nPageType);
			if( !pgTarget )
			{
				// create a new page
				WorksheetPage pgWks;
				if( strTemplate.IsEmpty() )
					strTemplate = LabTalk.System.Wks.DefTemplate$;
				
				pgWks.Create(strTemplate, CREATE_VISIBLE);
				pgTarget = pgWks;
			}
			Worksheet wksTarget = pgTarget.Layers();
			nRet = wksTarget.ImportASCII(strFilename, ai);
			
			wksTarget.UpdateOrigin();
			//wksTarget.SetASCIMP(ai);
		}
		break;
		
	case EXIST_PLOT:
		{
			GraphLayer gl = pg.Layers();
			if( !gl )
				return false;
		
			// create a new page
			WorksheetPage pgTemp;
			if( strTemplate.IsEmpty() )
				/// AW 11/02/06 QA80-9094 v8.0504 FIX_IMP_ASCII_TO_PLOT
				//LabTalk.System.Wks.DefTemplate$;
				strTemplate = "origin"; 
				/// END FIX_IMP_ASCII_TO_PLOT
			
			///---Sim 07-13-2007 IMPORT_TO_GRAPH_SHOULD_KEEP_WORKSHEET_IN_SIGHT
			/*
			///---Sim 06-04-2007 SOME_PAGES_TO_BE_EXCLUDED_FROM_MANAGER
			//int iOption = ( bMulti && 1 == FDLog.CheckStatus ) ? CREATE_VISIBLE : CREATE_HIDDEN;
			int iOption = ( bMulti && 1 == FDLog.CheckStatus ) ? CREATE_VISIBLE : CREATE_SET_MISSING_IN_MANAGER;
			///---END SOME_PAGES_TO_BE_EXCLUDED_FROM_MANAGER
			*/
			int iOption = ( bMulti && 1 == FDLog.CheckStatus ) ? CREATE_VISIBLE : CREATE_HIDDEN;
			///---END IMPORT_TO_GRAPH_SHOULD_KEEP_WORKSHEET_IN_SIGHT
			pgTemp.Create(strTemplate, iOption);
			
			Worksheet wksTemp = pgTemp.Layers();
			wksTemp.GetASCIMP(ai);
			/// AW 11/02/06 QA80-9094 v8.0504 FIX_IMP_ASCII_TO_PLOT
			//if( !strDesignation.IsEmpty() )
			if ( strDesignation.IsEmpty() )
				strDesignation = "XY";
			/// END FIX_IMP_ASCII_TO_PLOT			
				//wksTemp.SetColDesignations(strDesignation);
			wksTemp.SetColDesignations(strDesignation, false); /// Hong 09/26/07 QA80-9910 v8.0709 FIX_FAIL_PLOT_ALL_DATA_WHEN_DEFAULT_TEMPLATE_HAVE_MULTI_COLS
			
			nRet = wksTemp.ImportASCII(strFilename, ai);
			
			if( !bMulti || 0 == FDLog.CheckStatus )
			/// Hong 11/3/06 FIX_ERROR_LEGEND
			//gl.AddPlot(wksTemp);
			{
				gl.AddPlot(wksTemp);
				legend_update(gl);
			}
			/// end FIX_ERROR_LEGEND
		}
		break;
		
	case EXIST_MATRIX:
		{
			string str;
			str.Format("Open -W %s;", strFilename);
			LT_execute(str);
	
			MatrixLayer Matly = pg.Layers(0);
			MatrixObject mo(Matly, 0);
			/// Hong 10/19/06 FIX_FAIL_SETTING_DIMENSION
			/*
			matrix mat(mo);
			int nCol, nRow;
			mat.GetSourceDim(nRow, nCol);
			*/
			int nCol, nRow;
			nCol = mo.GetNumCols();
			nRow = mo.GetNumRows();
			/// end FIX_FAIL_SETTING_DIMENSION			
			Matrix Mat(Matly);
			Mat.SetXMin(1); Mat.SetXMax(nCol);
			Mat.SetYMin(1); Mat.SetYMax(nRow);
		}
		break;
		
	default:
		return false;
	}

	if( 0 == nRet )
		set_ascii_import_page_info(strFilename);
	else
		ERR_MSG("Import ASCII failed.");
		
	return true;
}

// use FDLog's current list
BOOL AscImportFDLOGFiles(string strBookSheet = "")
{
	using FDLog = LabTalk.FDLog;                 // Use LabTalk FDLog object

	char szFile[MAXFULLPATH], szTemplate[MAXFULLPATH], szDesignation[MAXFULLPATH];
	for( int ii = 0; ii < FDLog.MultiOpen.Count; ii++ )  // For each file selected
	{
		FDLog.Get("A", ii+1);                            // Get filename into LabTalk variable
		LT_get_str("%A", szFile, MAXFULLPATH);         // Get filename of selected file from LabTalk variable
		
		FDLog.GetTemplate("B", ii+1);	
		LT_get_str("%B", szTemplate, MAXFULLPATH);
		
		FDLog.GetColStr("Z", ii+1);
		LT_get_str("%Z", szDesignation, MAXFULLPATH);
		
		AscImport(szFile, strBookSheet, szTemplate, szDesignation, true);		
	}
	
	return true;
}
/// end MORE_IMPORT_MODE_IN_OLD_ASCII_IMPORT_DLG
/// end FIX_IMPORT_ASCII_FAIL_IMPORT_TO_GRAPH

///------ Folger 09/29/09 QA80-14392 IMPASC_FAILS_TO_IMPORT_NUMERIC_DATA_ON_GOS_WITH_DEFAULT_OPTIONS
int		check_get_numeric_separator_from_file(LPCSTR lpcszFile)
{
	ASCIMP	ai;
	if ( AscImpReadFileStruct(lpcszFile, &ai) == 0 )
	{
		return _check_get_numeric_separator_from_ai(ai);
	}

	return NF_IS_UNKNOWN;
}
///------ End IMPASC_FAILS_TO_IMPORT_NUMERIC_DATA_ON_GOS_WITH_DEFAULT_OPTIONS